/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

import java.util.List;

/**
 * This class encapsulates the information of a sun-resources.xml
 * packaged inside an application.
 */

public class SunResourcesXML {
    /** the relative path of this sun-resources.xml to the application root */
    private String xmlPath;
    
    /** the parsed resources list from this sun-resources.xml  */
    private List<Resource> resourcesList;
    
    public SunResourcesXML(String xPath, List<Resource> rList) {
        xmlPath = xPath;
        resourcesList = rList;
    }
    
    public String getXMLPath() {
        return xmlPath;
    }
    
    public void setXMLPath(String xPath) {
        xmlPath = xPath;
    }
    
    public List<Resource> getResourcesList() {
        return resourcesList;
    }
    
    public void setResourcesList(List<Resource> rList) {
        resourcesList = rList;
    }
    
}