/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jmac.config;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.web.security.WebSecurityManager;

public class HttpServletHelper extends ConfigHelper {
    private String realmName = null;

    public HttpServletHelper(String appContext, Map map,
            CallbackHandler cbh, String realmName) {

        if (map != null) {
            WebBundleDescriptor webBundle =
                (WebBundleDescriptor)map.get(HttpServletConstants.WEB_BUNDLE);
            LoginConfiguration loginConfig = null;
            if (webBundle != null) {
                loginConfig = webBundle.getLoginConfiguration();
                String policyContextId = WebSecurityManager.getContextID(webBundle);
                map.put(HttpServletConstants.POLICY_CONTEXT, policyContextId);
            }
            if (loginConfig != null && 
                    LoginConfiguration.CLIENT_CERTIFICATION_AUTHENTICATION.equals(
                    loginConfig.getAuthenticationMethod())) {
                this.realmName = CertificateRealm.AUTH_TYPE;
            } else {
                this.realmName = realmName;
            }
        }

        // setup DOL and realmName before init
        init(GFServerConfigProvider.HTTPSERVLET, appContext,
                map, cbh);
    }

    protected HandlerContext getHandlerContext(Map map) {
        final String fRealmName = realmName;
        return new HandlerContext() {
            public String getRealmName() {
                return fRealmName;
            }
        };
    }
}
