/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand.entry;

import com.sun.enterprise.server.ServerContext;


/**
 * Context of an entry to a servicegroup.
 * Each entry point generate such an EntryContext.
 * This object contains information regarding the entry.
 * Servicegroups use this EntryContext to examine the
 * entry request.
 *
 * @author Binod PG
 * @see EntryPoint 
 * @see ServerEntryListener 
 * @see ServiceGroup
 */
public class EntryContext {

    private Object context = null;
    private int type = -1;
    private ServerContext sc = null;

    /**
     * Creates an entrycontext. 
     * @param context COntext generated by entrypoints.
     * @param type One of the types specified in 
     * <code>EntryPoint</code> interface
     */
    public EntryContext(Object context, int type) {
        this.context = context;
        this.type = type;
    }

    // Return the type of entry.
    public int getEntryPointType() {
        return this.type;
    }

    // Set the entry point type
    public void setEntryPointType (int type) {
        this.type = type;
    }

    // Return the actual entry context.
    public Object get() {
        return context;
    }

    // Set the server context object. This will be used by
    // ServiceGroups.
    public void setServerContext(ServerContext sc) {
        this.sc = sc;
    }

    // Return the server context object.
    public ServerContext getServerContext() {
        return this.sc;
    }

    public String toString() {
        return "[ Entry context ] ...[ " + context + " ]";
    }

}
