/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.pluggable;

import java.util.Properties;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.pluggable.NotificationFactory;
import com.sun.enterprise.admin.target.TargetFactory;

import com.sun.enterprise.pluggable.Utils;

import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.enterprise.web.WebContainerAdminEventProcessor;
import com.sun.enterprise.diagnostics.DiagnosticAgent;
import com.sun.enterprise.deployment.pluggable.DeploymentFactory;

/**
 * Properties that define implementation classes for pluggable features
 * used with http engine from tomcat. An instance of this class
 * should be passed to getInstance() method of PluggableFeatureFactoryImpl
 * to create and have access to pluggable features.
 */
public class TomcatPluggableFeatureImpl extends Properties {

    /**
     * Properties to keep feature name and implementation classes.
     */
    protected static final Properties featureImplClasses = new Properties();

    static {
        featureImplClasses.setProperty(
            Utils.getNQClassName(InternalServicesList.class),
            "com.sun.enterprise.server.TomcatServices");
        featureImplClasses.setProperty(
            Utils.getNQClassName(LoggingSupport.class),
            "com.sun.enterprise.server.logging.TomcatLoggingSupport");
        featureImplClasses.setProperty(
            Utils.getNQClassName(ApplicationLoaderFactory.class),
            "com.sun.enterprise.server.pluggable.TomcatApplicationLoaderFactory");        
        featureImplClasses.setProperty(
            Utils.getNQClassName(DeploymentFactory.class),
            "com.sun.enterprise.deployment.pluggable.PEDeploymentFactory");

        featureImplClasses.setProperty(
            Utils.getNQClassName(NotificationFactory.class),
            "com.sun.enterprise.admin.event.pluggable.PENotificationFactory");
        featureImplClasses.setProperty(
            Utils.getNQClassName(TargetFactory.class),
            "com.sun.enterprise.admin.target.PETargetFactory");
        featureImplClasses.setProperty(
            Utils.getNQClassName(AdminContext.class),
            "com.sun.enterprise.admin.server.core.AdminContextImpl");
        featureImplClasses.setProperty(
            Utils.getNQClassName(WebContainerStartStopOperation.class),
            "com.sun.enterprise.web.PEWebContainerStartStopOperation");
        featureImplClasses.setProperty(
            Utils.getNQClassName(WebContainerAdminEventProcessor.class),
            "com.sun.enterprise.web.PEWebContainerAdminEventProcessor");
        featureImplClasses.setProperty(
            Utils.getNQClassName(SchemaUpdater.class),
            "com.sun.enterprise.web.PESchemaUpdater");        
        featureImplClasses.setProperty(
            Utils.getNQClassName(SecuritySupport.class),
            "com.sun.enterprise.security.SecuritySupportImpl");  
        featureImplClasses.setProperty(
            Utils.getNQClassName(WebContainerFeatureFactory.class),
            "com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl");
        featureImplClasses.setProperty(
            Utils.getNQClassName(DiagnosticAgent.class),
            "com.sun.enterprise.diagnostics.PEDiagnosticAgent");
        featureImplClasses.setProperty(
            Utils.getNQClassName(LBFeatureFactory.class),
            "com.sun.enterprise.server.pluggable.PELBFeatureFactoryImpl");
    }

    /**
     * Default constructor. 
     */
    public TomcatPluggableFeatureImpl() {
        super(featureImplClasses);
    }

}
