/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.ss;

import java.net.SocketAddress;
import java.net.InetSocketAddress;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ServerContext;

/**
 * Helper class representing configuration
 * of one Socket Service. 
 *
 * @see ASSocketService
 */
class ASSocketServiceConfig {

    private ConfigBean config = null;
    private String addressTag = null;
    private String portTag = null;
    private int port ;
    private String address = null;
    private SocketAddress sAddress = null;
    private boolean startSelector = true;

    ASSocketServiceConfig(ConfigBean config) {
        this.config = config;
    }

    void setAddressTag(String addressTag) {
        this.addressTag = addressTag;
    }

    String getAddressTag() {
        return this.addressTag;
    }

    void setPortTag(String  portTag) {
        this.portTag = portTag;
    }

    String getPortTag() {
        return this.portTag;
    }

    void setStartSelector(boolean flag) {
        this.startSelector = flag;
    }

    boolean getStartSelector() {
        return this.startSelector;
    }


    int getPort() {
        return this.port;
    }

    String getAddress() {
        return this.address;
    }

    SocketAddress getSocketAddress() {
        return this.sAddress;
    }

    void init() {
        this.port = Integer.parseInt(config.getAttributeValue(getPortTag()));

        if (getAddressTag() != null) {
            this.address = config.getAttributeValue(getAddressTag());
        }

        String address = getAddress();
        if (address != null) {
            this.sAddress = new InetSocketAddress(address, getPort());
        } else {
            this.sAddress = new InetSocketAddress(getPort());
        }
    }

    public String toString() {
        return getAddress() + ":" + getPort();
    }
}
