/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web;

import com.sun.enterprise.server.ServerContext;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.instance.InstanceEnvironment;

/**
 * This class implements the lifecycle methods used by the web
 * container subsystem.
 *
 * This class is intended for use in versions of the application server
 * that *do not* have web-core as well as in versions that do. NSAPI
 * specific functionality is implemented the NSAPIWebContainerLifecycle
 * subclass in the <code>j2ee-plugin</code> component.
 */
public class WebContainerLifecycle extends ServerLifecycleImpl {

    // --------------------------------------------------------- Public Methods

    /**
     * Server is initializing subsystems and setting up the runtime environment.
     * Prepare for the beginning of active use of the public methods of this
     * subsystem. This method is called before any of the public methods of 
     * this subsystem are utilized.  
     *
     * @param sc ServerContext the server runtime context.
     *
     * @exception IllegalStateException if this subsystem has already been
     *            started
     * @exception ServerLifecycleException if this subsystem detects a fatal 
     *            error that prevents this subsystem from being used
     */
    public void onInitialization(ServerContext sc) 
                        throws ServerLifecycleException {
    
        // Setup Catalina's environment
        InstanceEnvironment instance = sc.getInstanceEnvironment();
        System.setProperty("catalina.home", instance.getInstancesRoot());
        System.setProperty("catalina.base", instance.getInstancesRoot());
        System.setProperty("catalina.useNaming", "false");
    }

}
