/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.coyote;

import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.coyote.tomcat5.CoyoteResponse;
import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.logging.pwc.LogDomains;

/**
 * Customized version of the Tomcat 5 CoyoteResponse
 */
public class PECoyoteResponse extends CoyoteResponse {

    private static final Logger logger = LogDomains.getLogger(LogDomains.PWC_LOGGER);

    
    /*
     * Constructor.
     */
    public PECoyoteResponse(boolean chunkingDisabled) {
	super(chunkingDisabled);
    }


    // START GlassFish 898
    /**
     * Gets the string representation of the given cookie.
     *
     * @param cookie The cookie whose string representation to get
     *
     * @return The cookie's string representation
     */
    protected String getCookieString(Cookie cookie) {

        PwcWebModule wm = (PwcWebModule) getContext();
        boolean encodeCookies = false;
        if (wm != null && wm.getEncodeCookies()) {
            encodeCookies = true;
        }

        return getCookieString(cookie, encodeCookies);
    }
    // END GlassFish 898
}
