/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;

/**
 * Listener used to receive events from Catalina when a <code>Context</code>
 * is removed or when a <code>Host</code> is removed.
 *
 * @author Jean-Francois Arcand
 */
public class CatalinaListener  implements ContainerListener{
    
    public void containerEvent(ContainerEvent event) {    
        if (Container.REMOVE_CHILD_EVENT.equals(event.getType()) ) {
            Context context;
            String contextPath;
            Host host;

            Object container = event.getData();            
            if ( container instanceof Context) {
                context = (Context)container;
                
                if ( context != null 
                        && context.findConstraints().length == 0 
                        && context.findFilterDefs().length == 0 ){
                                
                    contextPath = context.getPath();
                    host = (Host)context.getParent();
                    int[] ports = host.getPorts();
                    for (int i=0; i < ports.length; i++){
                        removeContextPath(ports[i],contextPath); 
                    }
                }
            } 
        }  
    }  
    
    
    /**
     * Remove from the <code>FileCache</code> all entries related to 
     * the <code>Context</code> path.
     * @param port the <code>FileCacheFactory</code> port
     * @param contextPath the <code>Context</code> path
     */
    private void removeContextPath(int port, String contextPath) {        
        ArrayList<GrizzlyConfig> list = 
                GrizzlyConfig.getGrizzlyConfigInstances();
        for(GrizzlyConfig config: list){
            if (config.getPort() == port){
                config.invokeGrizzly("removeCacheEntry",
                        new Object[]{contextPath},
                        new String[]{"java.lang.String"});
            }
        }
    }  
}

