/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.io.IOException;
import java.lang.reflect.Method;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import javax.xml.soap.SOAPMessage;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletContext;

import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;

import com.sun.xml.ws.transport.http.servlet.ServletAdapter;

/**
 * Implementation of the Ejb Message Dispatcher for EJB3 endpoints.
 *
 * @author Jerome Dochez
 */
public class Ejb3MessageDispatcher implements EjbMessageDispatcher {
    
    private static Logger logger = 
        LogDomains.getLogger(LogDomains.EJB_LOGGER);    
    
    private static WsUtil wsUtil = new WsUtil();
    
    private WebServiceEngineImpl wsEngine;
    
    /** Creates a new instance of Ejb3MessageDispatcher */
    public Ejb3MessageDispatcher() {
        wsEngine = WebServiceEngineImpl.getInstance();
    }
    
    public void invoke(HttpServletRequest req, 
                       HttpServletResponse resp,
                       ServletContext ctxt,
                       EjbRuntimeEndpointInfo endpointInfo) {
        
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JAXWS WebServiceDispatcher " + req.getMethod() + 
                   " entering for " + req.getRequestURI() + " and query string " + req.getQueryString());
        }       
        String method = req.getMethod();
        try {
            if( method.equals("POST") ) {
                handlePost(req, resp, endpointInfo);
            } else if( method.equals("GET") ) {
                handleGet(req, resp, ctxt, endpointInfo);
            } else {
                String errorMessage =  "Unsupported method request = [" 
                    + method + "] for endpoint " + 
                    endpointInfo.getEndpoint().getEndpointName() + " at " + 
                    endpointInfo.getEndpointAddressUri();
                logger.warning(errorMessage);
                wsUtil.writeInvalidMethodType(resp, errorMessage);
            }
        } catch(Exception e) {
            logger.log(Level.WARNING, "ejb endpoint exception", e);
        }
    } 
    
    private void handlePost(HttpServletRequest req,
                            HttpServletResponse resp,
                            EjbRuntimeEndpointInfo endpointInfo)
        throws IOException    {        
        try {            
            try {
                ServletAdapter adapter = 
                        (ServletAdapter) endpointInfo.prepareInvocation(true);
                
                if (adapter != null) {                    
                    adapter.handle(null, req, resp);
                } else {
                    logger.log(Level.SEVERE, 
                            "Unable to find adpater for endpoint " + endpointInfo.getEndpoint().getName());
                }
            } finally {
                // Always call release, even if an error happened
                // during getImplementor(), since some of the
                // preInvoke steps might have occurred.  It's ok
                // if implementor is null.
                endpointInfo.releaseImplementor();
            }    
        } catch (Throwable e) {
            String errorMessage = "invocation error on ejb endpoint " +
            endpointInfo.getEndpoint().getEndpointName() + " at " +
            endpointInfo.getEndpointAddressUri() + " : " + e.getMessage();
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }    
    
    private void handleGet(HttpServletRequest req, 
                           HttpServletResponse resp,
                           ServletContext ctxt,
                           EjbRuntimeEndpointInfo endpointInfo)
                            throws IOException    {
        try {
            ServletAdapter adapter = 
                    (ServletAdapter) endpointInfo.prepareInvocation(false);
            if (adapter != null) {                    
                adapter.publishWSDL(ctxt, req, resp);
            } else {
                String message = "Invalid wsdl request " +  req.getRequestURL();
                (new WsUtil()).writeInvalidMethodType(resp, message);
            }
        } catch (Throwable e) {
            String errorMessage = "invocation error on ejb endpoint " +
            endpointInfo.getEndpoint().getEndpointName() + " at " +
            endpointInfo.getEndpointAddressUri() + " : " + e.getMessage();
            logger.log(Level.WARNING, errorMessage, e);
            String binding = endpointInfo.getEndpoint().getProtocolBinding();
            WsUtil.raiseException(resp, binding, errorMessage);
        }
    }      
}
