/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.util.HashMap;
import java.lang.reflect.Method;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.Provider;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/**
 * This extends InvokerImpl - the difference is this creates
 * a Map of methods from class to proxy class
 */
public class EjbInvokerImpl extends InvokerImpl {
    
    private HashMap methodMap = null;
    private Class endpointImplClass;
    
    public EjbInvokerImpl(Class endpointImpl, Invoker core, 
            Object inv, WebServiceContextImpl w) {
        super(core, inv, w);
        endpointImplClass = endpointImpl;
    }
    
    /**
     * Here is where we actually call the endpoint method
     */
    public Object invoke(Packet p, Method m, Object... args ) 
                                throws InvocationTargetException, IllegalAccessException {
        if(methodMap == null) {
            methodMap = new HashMap();
            Class proxyClass = invokeObject.getClass();
            for(Method x : endpointImplClass.getMethods()) {
                try {
                    Method mappedMethod = 
                        proxyClass.getMethod(x.getName(), x.getParameterTypes());
                    methodMap.put(x, mappedMethod);
                } catch (NoSuchMethodException noex) {
                    // We do not take any action because these may be excluded @WebMethods
                    // or EJB business methods that are not @WebMethods etc
                    continue;
                }
            }            
        }
        Method mappedMethod = 
                (Method) methodMap.get(m);
        if(mappedMethod != null)
            return(super.invoke(p, mappedMethod,  args));
        throw new IllegalAccessException("Unable to find invocation method");
    }
}
