/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import javax.xml.namespace.QName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.http.HTTPBinding;

import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;

import com.sun.enterprise.deployment.WebServiceEndpoint;

import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.enterprise.webservice.monitoring.HttpResponseInfoImpl;
import com.sun.enterprise.webservice.monitoring.ThreadLocalInfo;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;

/**
 * This pipe is used to do app server monitoring
 */
public class MonitoringPipe extends AbstractFilterPipeImpl {

    private final SEIModel seiModel;
    private final WSDLPort wsdlModel;
    private final WSEndpoint owner;
    private final WebServiceEndpoint endpoint;
    private final WebServiceEngineImpl wsEngine;
    
    public MonitoringPipe(ServerPipeAssemblerContext ctxt, Pipe tail,
                            WebServiceEndpoint ep) {
        super(tail);
        this.endpoint = ep;
        this.seiModel = ctxt.getSEIModel();
        this.wsdlModel = ctxt.getWsdlModel();
        this.owner = ctxt.getEndpoint();
        wsEngine = WebServiceEngineImpl.getInstance();
    }

    public MonitoringPipe(MonitoringPipe that, PipeCloner cloner) {
        super(that, cloner);
        this.endpoint = that.endpoint;
        this.seiModel = that.seiModel;
        this.wsdlModel = that.wsdlModel;
        this.owner = that.owner;
        wsEngine = WebServiceEngineImpl.getInstance();
    }

    public final Pipe copy(PipeCloner cloner) {
        return new MonitoringPipe(this, cloner);
    }
    
    public Packet process(Packet request) {
        // if it is a JBI request then skip the monitoring logic. This is done 
        // as HTTPServletRequest/Response is not available when the invocation 
        // is from JavaEE service engine.
        if(ServiceEngineUtil.isJBIRequest(request.webServiceContextDelegate.getClass().getName())) {
            return next.process(request);
        }
        // No monitoring available for restful services
        if(HTTPBinding.HTTP_BINDING.equals(endpoint.getProtocolBinding())) {
            return next.process(request);
        }
        SOAPMessageContext ctxt = new SOAPMessageContextImpl(request);
        HttpServletRequest httpRequest = 
                (HttpServletRequest) request.get(javax.xml.ws.handler.MessageContext.SERVLET_REQUEST);
        HttpServletResponse httpResponse = 
                (HttpServletResponse) request.get(javax.xml.ws.handler.MessageContext.SERVLET_RESPONSE);

        String messageId=null;
        if (wsEngine.getGlobalMessageListener()!=null) {
            Endpoint endpt;
            if(endpoint.implementedByWebComponent()) {
                endpt = wsEngine.getEndpoint(httpRequest.getServletPath());
            } else {
                endpt = wsEngine.getEndpoint(httpRequest.getRequestURI());
            }             
            messageId = wsEngine.preProcessRequest(endpt);  
            if (messageId!=null) {
                ctxt.put(EndpointImpl.MESSAGE_ID, messageId);
                ThreadLocalInfo config = new ThreadLocalInfo(messageId, httpRequest);
                wsEngine.getThreadLocal().set(config);
            }
        }
                                
        JAXWSEndpointImpl endpt = null;
        try {
            if (wsEngine.getGlobalMessageListener()!=null) {
                if(endpoint.implementedByWebComponent()) {
                    endpt = 
                        (JAXWSEndpointImpl)wsEngine.getEndpoint(httpRequest.getServletPath());
                } else {
                    endpt = 
                        (JAXWSEndpointImpl)wsEngine.getEndpoint(httpRequest.getRequestURI());
                }             
                endpt.processRequest(ctxt);
            }
        } catch (Exception e) {
            // temporary - need to send back SOAP fault message
        }

        Packet pipeResponse = next.process(request);

        try {
            if(endpt != null) {
                endpt.processResponse(ctxt);
            }
        } catch (Exception e) {
            // temporary - need to send back SOAP fault message
        }
        
        if (messageId!=null) {
            HttpResponseInfoImpl info = new HttpResponseInfoImpl(httpResponse);
            wsEngine.postProcessResponse(messageId, info);
        }        
        return pipeResponse;
    }    
}
