/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.util.HashMap;

import javax.xml.ws.http.HTTPBinding;

import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.policy.PolicyMap;

import com.sun.enterprise.deployment.WebServiceEndpoint;

/**
 * This is used by JAXWSContainer to return proper 196 security and
 *  app server monitoing pipes to the StandAlonePipeAssembler and 
 *  TangoPipeAssembler
 */
public class ServerPipeCreator extends ServerPipelineHook {
    
    private WebServiceEndpoint endpoint;
    private boolean isHttpBinding;

    public ServerPipeCreator(WebServiceEndpoint ep){
        endpoint = ep;
	isHttpBinding = 
	    ((HTTPBinding.HTTP_BINDING.equals
	      (endpoint.getProtocolBinding())) ? true : false); 
    }
    
    public Pipe createMonitoringPipe(ServerPipeAssemblerContext ctxt, Pipe tail) {
        return new MonitoringPipe(ctxt, tail, endpoint);
    }    
    
    public Pipe createSecurityPipe(PolicyMap map, SEIModel sei,
            WSDLPort port, WSEndpoint owner, Pipe tail) {

	HashMap props = new HashMap();

	props.put(PipeConstants.POLICY,map);
	props.put(PipeConstants.SEI_MODEL,sei);
	props.put(PipeConstants.WSDL_MODEL,port);
	props.put(PipeConstants.ENDPOINT,owner);
	props.put(PipeConstants.SERVICE_ENDPOINT,endpoint);
	props.put(PipeConstants.NEXT_PIPE,tail);

        return new CommonServerSecurityPipe(props, tail, isHttpBinding);
    }    
}
