/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import javax.xml.namespace.QName;
import java.net.URL;

/**
 * Provides a Facade to ServiceEngine from appserver .
 * @author Manisha Umbarje
 */
public interface ServiceEngineFacade {
    /**
     * Creates ClientTransportFactory to route messages through NMR
     */
     public Object getTransportFactory(ServiceRefPortInfo portInfo,
             boolean oneWay) throws Exception;
     
     /**
      * Enables/Disables end points in NMR.
      */
     public void handleWebServiceEndpointEvent(String endpointUri, 
             boolean disableEndpoint) throws Exception ;
     
     public Pipe createJBITransportPipe(WSBinding binding, 
                                        URL wsdlLocation, 
                                        QName service,
                                        WSDLPort wsdlPort);

     public boolean hasConsumerEP(QName serviceName, String endpointName);
}

