/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.Container;

import javax.xml.namespace.QName;
import java.util.logging.Logger;
import java.util.logging.Level;
/**
 * If web service client is JBI enabled, transport factory is set to NMR, otherwise
 * ususal JAXWS stack is used.
 * @author Manisha Umbarje
 */
public class ServiceEngineUtil {
    
    public static String JBI_ENABLED = "jbi-enabled";
    private static final String SE_DISABLE_PROPERTY = "com.sun.enterprise.jbi.se.disable";
    private static String seDisablePropertyValue = null;
    private static boolean seEnabledFlag = true;

    private static Logger logger =
            LogDomains.getLogger(LogDomains.SERVER_LOGGER);
    /** Creates a new instance of ServiceEngineUtil */
    public ServiceEngineUtil() {
    }
    
    public static boolean isServiceJBIEnabled(ServiceReferenceDescriptor desc) {
        if(isServiceEngineEnabled()) {
            java.util.Set portsInfo = desc.getPortsInfo();
            java.util.Iterator ports = portsInfo.iterator();
            while(ports.hasNext()) {
                ServiceRefPortInfo portDesc = (ServiceRefPortInfo)ports.next();
                if(isPortJbiEnabled(portDesc))
                    return true;
            }
        }
        return false;
    }
    
    public static void setJBITransportFactory(ServiceRefPortInfo portInfo,
            Object stubObj, boolean jbiEnabled) {
        if(isServiceEngineEnabled()) {
            ServiceReferenceDescriptor serviceRef = portInfo.getServiceReference();
            if(serviceRef != null && stubObj != null) {
                if (isServiceEngineEnabled() && 
                        jbiEnabled && 
                        serviceRef.getMappingFileUri() != null) {
                    setTransportFactory((com.sun.xml.rpc.spi.runtime.StubBase)stubObj, portInfo);
                    
                }
                
            }
        } else {
            logger.log(Level.INFO, "Java EE Service Engine's functionality is disabled");
        }
        
    }
    
     public static boolean isServiceEngineEnabled() {
        //safe to assume that JBI is installed
        if(seDisablePropertyValue == null) {
            seDisablePropertyValue = System.getProperty(SE_DISABLE_PROPERTY);
            logger.log(Level.FINE,SE_DISABLE_PROPERTY ," value is " + seDisablePropertyValue);
            if(seDisablePropertyValue != null)
                seEnabledFlag = "false".equals(seDisablePropertyValue);
        }
        return seEnabledFlag;
    }

    public static ServiceRefPortInfo getPortInfo(WSClientContainer container, 
                                                 QName portName) {
        return container.svcRef.getPortInfoByPort(portName);
    }
    
    public static boolean isJBIRequest(String delegateClassName) {
        return delegateClassName.equals("com.sun.enterprise.jbi.serviceengine." +
                                        "bridge.transport.NMRServerConnection");
    }
    
    private static boolean isPortJbiEnabled(ServiceRefPortInfo portInfo) {
        if(portInfo != null) {
            String value = portInfo.getStubPropertyValue(JBI_ENABLED);
            logger.log(Level.FINEST, "JBI_ENABLED flag value is : " + value);
            return "true".equals(value);
        } else {
            // This means the deployer did not resolve the port to
            // which this SEI is mapped, return false;
        }
        return false;
    }
    
    private static void setTransportFactory(
            com.sun.xml.rpc.spi.runtime.StubBase stubObj, ServiceRefPortInfo portInfo) {
        try {
            // This is done to avoide classloader issues.
            // Check out ServiceEngineRtObjectFactory for more details.
            com.sun.xml.rpc.spi.runtime.ClientTransportFactory factory =
                    (com.sun.xml.rpc.spi.runtime.ClientTransportFactory)
                    ServiceEngineRtObjectFactory.getInstance().
                    getFacade().getTransportFactory(portInfo, true);
            if (factory == null)
                return ;
            
            logger.log(Level.INFO, "Before setting setTransportFactory to NMR");
            // Set JBI transport factory
            stubObj._setTransportFactory(factory);
            
        } catch(Exception e) {
            // Do nothing.
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING,
                        "Error during setting of transport factory"+e.getMessage());
            }
        }
    }
}
