/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.security.Principal;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.EndpointReference;
import com.sun.web.security.WebPrincipal;
import com.sun.enterprise.Switch;
import com.sun.enterprise.InvocationManager;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.api.message.Packet;

public class WebServiceContextImpl implements WSWebServiceContext {
    
    public static ThreadLocal msgContext = new ThreadLocal();
    
    public static ThreadLocal principal = new ThreadLocal();

    private WSWebServiceContext jaxwsContextDelegate;

    public void setContextDelegate(WSWebServiceContext wsc) {
        this.jaxwsContextDelegate = wsc;
    }
    
    public MessageContext getMessageContext() {
        return this.jaxwsContextDelegate.getMessageContext();
    }

    public void setMessageContext(MessageContext ctxt) {
        msgContext.set(ctxt);
    }

    /*
     * this may still be required for EJB endpoints
     *
     */
    public void setUserPrincipal(WebPrincipal p) {
        principal.set(p);
    }
    
    public Principal getUserPrincipal() {
        // This could be an EJB endpoint; check the threadlocal variable
        WebPrincipal p = (WebPrincipal) principal.get();
        if (p != null) {
            return p;
        }
        // This is a servlet endpoint
        return this.jaxwsContextDelegate.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        Switch sw = Switch.getSwitch();
        InvocationManager mgr = sw.getInvocationManager();
        Object o = mgr.getCurrentInvocation().getContainerContext();
        if(o instanceof StatelessSessionContainer) {
            StatelessSessionContainer cont = (StatelessSessionContainer) o;
            boolean res = cont.getSecurityManager().isCallerInRole(role);
            return res;
        }
        // This is a servlet endpoint
        return this.jaxwsContextDelegate.isUserInRole(role);
    }
    
    public EndpointReference getEndpointReference(Class clazz, org.w3c.dom.Element... params) {
        return this.jaxwsContextDelegate.getEndpointReference(clazz, params);
    }
    
    public EndpointReference getEndpointReference(org.w3c.dom.Element... params) {
        return this.jaxwsContextDelegate.getEndpointReference(params);
    }
    
    public Packet getRequestPacket() {
        return this.jaxwsContextDelegate.getRequestPacket();
    }
}
