/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EndpointImpl.java
 *
 * Created on March 14, 2005, 10:35 AM
 */

package com.sun.enterprise.webservice.monitoring;

import java.util.List;
import java.util.ArrayList;

import com.sun.enterprise.deployment.WebServiceEndpoint;

/**
 * Implementation of the endpoint interface
 *
 * @author Jerome Dochez
 */
public class EndpointImpl implements Endpoint {
    
    public final static String NAME = "MONITORING_ENDPOINT";
    public final static String MESSAGE_ID = "MONITORING_MESSAGE_ID";
    public final static String REQUEST_TRACE = "MONITORING_REQUEST_MESSAGE_TRACE";
    
    final String endpointSelector;
    final EndpointType type;
    WebServiceEndpoint endpointDesc;
    List<MessageListener> listeners = new ArrayList<MessageListener>();
    
    /** Creates a new instance of EndpointImpl */
    EndpointImpl(String endpointSelector, EndpointType type) {
        this.endpointSelector = endpointSelector;
        this.type = type;
    }
    
    /** 
     * @return the endpoint URL as a string. This is the URL
     * web service clients use to invoke the endpoint.
     */
    public String getEndpointSelector() {        
        return endpointSelector;
    }
        
    /**
     * @return the endpoint type
     */
    public EndpointType getEndpointType() {
        return type;
    }
    
    /**
     * Returns the Transport type 
     */
    public TransportType getTransport() {
        return TransportType.HTTP;
    }
    
    /**
     * registers a new SOAPMessageListener for this endpoint
     * @param the listener instance to register.
     */
    public void addListener(MessageListener newListener) {
        listeners.add(newListener);
    }
    
    /**
     * unregiters a SOAPMessageListener for this endpoint
     * @param the listener instance to unregister.
     */
    public void removeListener(MessageListener listener) {
        listeners.remove(listener);
    }
    
    /** 
     * Returns true if this endpoint has listeners registered
     * @return true if at least one listener is registered
     */
    public boolean hasListeners() {
        return !listeners.isEmpty();
    }
    
    /**
     * Return the deployment descriptors associated with this 
     * endpoint.
     */
    public WebServiceEndpoint getDescriptor() {
        return endpointDesc;
    }
    
    /**
     * Set the WebServiceEndpoint DOL descriptor
     */
    public void setDescriptor(WebServiceEndpoint endpointDesc) {
        
        if (endpointDesc!=null) {
            endpointDesc.addExtraAttribute(EndpointImpl.NAME, this);        
        }
        this.endpointDesc = endpointDesc;
    }    
}
