/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.web.security;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;


class HttpResponseWrapper extends HttpServletResponseWrapper 
        implements HttpResponse {
        
    private HttpResponse httpResponse;         

    HttpResponseWrapper(HttpResponse response,
            HttpServletResponse servletResponse) {
        super(servletResponse);
        httpResponse = response;
    }
    
    // ----- HttpResponse Methods -----
    public Cookie[] getCookies() {
        return httpResponse.getCookies();
    }
    
    public String getHeader(String name) {
        return httpResponse.getHeader(name);
    }
    
    public String[] getHeaderNames() {
        return httpResponse.getHeaderNames();
    }
    
    public String[] getHeaderValues(String name) {
        return httpResponse.getHeaderValues(name);
    }
    
    public String getMessage() {
        return httpResponse.getMessage();
    }

    public int getStatus() {
        return httpResponse.getStatus();
    }
    
    public void reset(int status, String message) {
        httpResponse.reset(status, message);
    }
    
    // ----- Response Methods -----
    public Connector getConnector() {
        return httpResponse.getConnector();
    }
    
    public void setConnector(Connector connector) {
        httpResponse.setConnector(connector);
    }
    
    public int getContentCount() {
        return httpResponse.getContentCount();
    }
    
    public Context getContext() {
        return httpResponse.getContext();
    }

    public void setContext(Context context) {
        httpResponse.setContext(context);
    }

    public void setAppCommitted(boolean appCommitted) {
        httpResponse.setAppCommitted(appCommitted);
    }

    public boolean isAppCommitted() {
        return httpResponse.isAppCommitted();
    }

    public boolean getIncluded() {
        return httpResponse.getIncluded();
    }
    
    public void setIncluded(boolean included) {
        httpResponse.setIncluded(included);
    }

    public String getInfo() {
        return httpResponse.getInfo();
    }

    public Request getRequest() {
        return httpResponse.getRequest();
    }

    public void setRequest(Request request) {
        httpResponse.setRequest(request);
    }

    public ServletResponse getResponse() {
        return super.getResponse();
    }
    
    public OutputStream getStream() {
        return httpResponse.getStream();
    }

    public void setStream(OutputStream stream) {
        httpResponse.setStream(stream);
    }

    public void setSuspended(boolean suspended) {
        httpResponse.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return httpResponse.isSuspended();
    }

    public void setError() {
        httpResponse.setError();
    }

    public boolean isError() {
        return httpResponse.isError();
    }

    public void setDetailMessage(String message) {
        httpResponse.setDetailMessage(message);
    }

    public String getDetailMessage() {
        return httpResponse.getDetailMessage();
    }
    
    public ServletOutputStream createOutputStream() throws IOException {
        return httpResponse.createOutputStream();
    }

    public void finishResponse() throws IOException {
        httpResponse.finishResponse();
    }
    
    public int getContentLength() {
        return httpResponse.getContentLength();
    }
    
    /* Delegate to HttpServletResponse
      public String getContentType() {
      return httpResponse.getContentType();
      }
      */

    public PrintWriter getReporter() throws IOException {
        return httpResponse.getReporter();
    }

    public void recycle() {
        httpResponse.recycle();
    }

    /* Delegate to HttpServletResponse
       public void resetBuffer() {
       httpResponse.resetBuffer();
       }
       */

    public void sendAcknowledgement() throws IOException {
        httpResponse.sendAcknowledgement();
    }
}
