/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.grizzly.asyncweb;

import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.algorithms.StreamAlgorithmBase;
import com.sun.enterprise.web.connector.grizzly.algorithms.
        StreamAlgorithmBase.DummyHandler;
import java.nio.ByteBuffer;


/**
 * AsyncWeb customized algorithm. The difference between this algorithm and 
 * the <code>NoParsingAlgorithm</code> is that ByteBuffer aren't flipped
 * until we wrap them using the MINA ByteBuffer implementation.
 *
 * @author Jeanfrancois Arcand
 */
public class AsyncWebStreamAlgorithm extends StreamAlgorithmBase{
    
    public AsyncWebStreamAlgorithm() {
        handler = new DummyHandler();
    }
    
    
    /**
     * Do not parse the bytes and automatically flip the <code>ByteBuffer</code>
     */
    public boolean parse(ByteBuffer byteBuffer){
        curLimit = byteBuffer.limit();
        curPosition = byteBuffer.position();
        return true;
    }

    
    /**
     * Return the <code>Handler</code> used by this algorithm.
     */
    public Handler getHandler(){
        return handler;
    }
    
    
    /***
     * Recycle this object.
     */
    public void recycle(){
        super.recycle();
        
        socketChannel = null;
    } 
 
        
    /**
     * Return the class responsible for handling OP_READ.
     */
    public Class getReadTask(SelectorThread selectorThread){
        return com.sun.enterprise.web.connector.grizzly.XAReadTask.class;
    }
}
