/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly;

import java.util.concurrent.ThreadFactory;

/**
 * Customized <code>ThreadFactory</code> used by the <code>Pipeline</code>
 * instance.
 *
 * @author Jean-Francois Arcand
 */
public class GrizzlyThreadFactory implements ThreadFactory{

    /**
     * The name used when creating threads
     */
    protected String name;
    
    /**
     * The port used when created threads' name.
     */
    protected int port;
    
    /**
     * The number of created threads.
     */
    protected int threadCount;
    
    
    /**
     * The priority used when creating threads.
     */
    protected int priority;

    
    /**
     * The <code>ThreadGroup</code> used.
     */
    private final static ThreadGroup threadGroup = new ThreadGroup("Grizzly");
    
    /**
     * Create an instance of <code>ThreadFactory</code>
     * @param name the name of thread who will be created by this factory
     * @param port the port of thread who will be created by this factory
     * @param priority the priority of thread who will be created by this factory 
     */
    public GrizzlyThreadFactory(String name, int port,int priority){
        this.name = name;
        this.port = port;
        this.priority = priority;
    }


    /**
     * Create a new thread.
     * @param r an instance of a <code>Task</code>.
     * @return a new Thread.
     */
    public Thread newThread(Runnable r){
        WorkerThreadImpl t = new WorkerThreadImpl(threadGroup,r);
        t.setName(name + "WorkerThread-"  + port + "-" + threadCount);
        t.setPriority(priority);
        t.setDaemon(true);
      
        threadCount++;
        return t;
    }

    
    /**
     * Return the <code>ThreadGroup</code> used by this factory
     */
    public ThreadGroup getThreadGroup(){
        return threadGroup;
    }
    
    
    /**
     * Interrupt the <code>Thread</code> using it thread id
     */
    public boolean interruptThread(long threadID){
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
               
        for (Thread thread: threads){
            if ( thread != null && thread.getId() == threadID ){                
                if ( Thread.State.RUNNABLE != thread.getState()){
                    try{
                        thread.interrupt();
                        return true;
                    } catch (Throwable t){
                        ; // Swallow any exceptions.
                    }
                }
            }
        }
        return false;
    }
}
