/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.grizzly;

/**
 * An interface used as a wrapper around any kind of thread pool
 *
 * @author Jean-Francois Arcand
 */
public interface Pipeline {

    /**
     * Add an <code>Task</code> to be processed by this <code>Pipeline</code>
     */
    public void addTask(Task task) ;


    /**
     * Return a <code>Task</code> object available in the pipeline.
     */
    public Task getTask() ;
    
   
   /**
     * Return the number of waiting threads.
     */
    public int getWaitingThread();
    
    
    /** 
     * Return the number of threads used by this pipeline.
     */
    public int getMaxThreads();
    
    
    /**
     * Return the number of active threads.
     */
    public int getCurrentThreadCount() ;
      
      
    /**
     * Return the curent number of threads that are currently processing 
     * a task.
     */
    public int getCurrentThreadsBusy();
    
   
    /**
     * Init the <code>Pipeline</code> by initializing the required
     * <code>WorkerThread</code>. Default value is 10
     */
    public void initPipeline();


    /**
     * Return the name of this <code>Pipeline</code>
     */
    public String getName();


    /**
     * Start the <code>Pipeline</code>
     */
    public void startPipeline();
    

    /**
     * Stop the <code>Pipeline</code> 
     */
    public void stopPipeline();

    
    /**
     * Set the <code>Thread</code> priority used when creating new threads.
     */
    public void setPriority(int priority);
    
    
    /**
     * Set the maximum thread this pipeline can handle.
     */
    public void setMaxThreads(int maxThread);
    
    
    /**
     * Set the minimum thread this pipeline can handle.
     */    
    public void setMinThreads(int minThread);
    
    
    /**
     * Set the port this <code>Pipeline</code> is associated with.
     */
    public void setPort(int port);
    
    
    /**
     * Set the name of this <code>Pipeline</code>
     */
    public void setName(String name);
   
    
    /**
     * Set the maximum pending connection this <code>Pipeline</code>
     * can handle.
     */
    public void setQueueSizeInBytes(int maxQueueSizeInBytesCount);
    
   
    /**
     * Set the number the <code>Pipeline</code> will use when increasing the 
     * thread pool
     */
    public void setThreadsIncrement(int processorThreadsIncrement);
    
    
    /**
     * Set the timeout value a thread will use to times out the request.
     */
    public void setThreadsTimeout(int processorThreadsTimeout);
    

    /**
     * Set the <code>PipelineStatistic</code> object used
     * to gather statistic;
     */
    public void setPipelineStatistic(PipelineStatistic pipelineStatistic);
    
    
    /**
     * Return the <code>PipelineStatistic</code> object used
     * to gather statistic;
     */
    public PipelineStatistic getPipelineStatistic();


    /**
     * Returns the number of tasks in this <code>Pipeline</code>.
     *
     * @return Number of tasks in this <code>Pipeline</code>.
     */
    public int size();


    // ------------------- Not used, compatibility with 8.1 --------------/
    /**
     * Return the number of maximum spare thread.
     */
    public int getMaxSpareThreads();

    /**
     * Return the number of minimum spare thread.
     */
    public int getMinSpareThreads();


    /**
     * Set the number of minimum spare thread.
     */
    public void setMinSpareThreads(int minSpareThreads);
    
    
    /**
     * Interrup the <code>Thread</code> using it thread id
     */
    public boolean interruptThread(long threadId);
}
