/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly.comet;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.coyote.Request;

/**
 * AJAX/Comet support using the Grizzly Asynchronous Request Processing 
 * default mechanism.
 *
 * Instance of this class represent an interrupted/polled/Comet request. 
 * 
 * Note: The request can be resumed anytime, and the polled request is not 
 * holding a thread.
 *
 * @author Jeanfrancois Arcand
 */
public class CometAsyncFilter implements AsyncFilter {       
 
    /**
     * Main logger
     */
    private final static Logger logger = SelectorThread.logger();
        
    
    /**
     * Comet Async Filter.
     */
    public CometAsyncFilter() {
    }

    
    /**
     * Execute the Comet <code>AsyncFilter</code> by delegating the work to the 
     * <code>CometEngine</code>. At this stage, the request has already
     * been interrupted.
     */
    public boolean doFilter(AsyncExecutor asyncExecutor) {
        AsyncProcessorTask apt = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
        CometEngine cometEngine = CometEngine.getEngine();                
        try{
            if (!cometEngine.handle(apt)) {
                return true;
            } 
        } catch (IOException ex){
            logger.log(Level.SEVERE,"CometAsyncFilter",ex);
        }
        return false;
    }
}
