/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly.comet;

/**
 * Simple event class used to pass information between <code>CometHandler</code>
 * and the Comet implementation.
 *
 * @author Jeanfrancois Arcand
 */
public class CometEvent<E> {
    
    /**
     * Interrupt the <code>CometHandler</code>.
     */
    public final static int INTERRUPT = 0;
    
    
    /**
     * Notify the <code>CometHandler</code>.
     */
    public final static int NOTIFY = 1;
    
    
    /**
     * Initialize the <code>CometHandler</code>.
     */    
    public final static int INITIALIZE = 2;
    
    
    /**
     * Terminate the <code>CometHandler</code>.
     */     
    public final static int TERMINATE = 3;    
    
    
    /**
     * Notify the <code>CometHandler</code> of available bytes.
     */       
    public final static int READ = 4;
    
    
    /**
     * This type of event.
     */
    protected int type;

    
    /**
     * Share an <code>E</code> amongst <code>CometHandler</code>
     */
    protected E attachment;
    
    
    /**
     * The CometContext from where this instance was fired.
     */
    private CometContext cometContext;
    
    
    /**
     * Create a new <code>ComettEvent</code>
     */
    public CometEvent() {
        type = NOTIFY;
    }
    
    
    /**
     * Return the <code>type</code> of this object.
     * @return int Return the <code>type</code> of this object
     */
    public int getType(){
        return type;
    }
    
    
    /**
     * Set the <code>type</code> of this object.
     * @param int the <code>type</code> of this object
     */    
    public void setType(int type){
        this.type = type;
    }
    
    
    /**
     * Attach an <E>
     * @param attachment An attachment. 
     */
    public void attach(E attachment){
        this.attachment = attachment;
    }
    
    
    /**
     * Return the attachment <E>
     * @return attachment An attachment. 
     */    
    public E attachment(){
        return attachment;
    }

    
    /**
     * Return the <code>CometContext</code> that fired this event.
     */
    public CometContext getCometContext() {
        return cometContext;
    }

    
    /**
     * Set the <code>CometContext</code> that fired this event.
     */
    public void setCometContext(CometContext cometContext) {
        this.cometContext = cometContext;
    }
    
}
