/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.WorkerThreadImpl;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;

/**
 * Simple <code>WorkerThread</code> used to execute SSL over NIO requests. All
 * <code>ByteBuffer</code> used by this class MUST be created by client
 * of this classes.
 *
 * @author Jean-Francois Arcand
 */
public class SSLWorkerThread extends WorkerThreadImpl{

    /**
     * The encrypted ByteBuffer used for handshaking and reading request bytes.
     */
    private ByteBuffer inputBB;
    

    /**
     * The encrypted ByteBuffer used for handshaking and writing response bytes.
     */    
    private ByteBuffer outputBB;

    
    /**
     * The <code>SSLEngine</code> used to manage the SSL over NIO request.
     */
    private SSLEngine sslEngine;

    
    /** 
     * Create a Thread that will synchronizes/block on 
     * <code>SSLPipeline</code> instance.
     */
    public SSLWorkerThread(ThreadGroup threadGroup, Runnable runnable){
        super(threadGroup, runnable);    
    }    
    
    
    /** 
     * Create a Thread that will synchronizes/block on 
     * <code>SSLPipeline</code> instance.
     */
    public SSLWorkerThread(Pipeline pipeline, String name){
        super(pipeline, name);  
    }
    
    /**
     * Perform a <code>Task</code> processing.
     */
    public void run(){

        if ( target != null ){
            target.run();
            return;
        }
        
        while (doTask) {
            try{
                // Wait for a Task to be added to the pipeline.
                Task t = pipeline.getTask();
                if (t != null){
                    t.run();                
                    t = null;
                }
            } catch (Throwable t) {         
                // Make sure we aren't leaving any bytes after an exception.
                if (byteBuffer != null){
                    byteBuffer.clear();
                }
                if (inputBB != null){
                    inputBB.clear();
                }
                if (outputBB != null){
                    outputBB.clear();
                }     
                SelectorThread.logger().log(Level.FINE,
                        "workerThread.httpException",t);
            } finally {
                sslEngine = null;
            }
        }
    }

    
    /**
     * Return the encrypted <code>ByteBuffer</code> used to handle request.
     */
    public ByteBuffer getInputBB(){
        return inputBB;
    }
    
    
    /**
     * Set the encrypted <code>ByteBuffer</code> used to handle request.
     */    
    public void setInputBB(ByteBuffer inputBB){
        this.inputBB = inputBB;
    }
 
    
    /**
     * Return the encrypted <code>ByteBuffer</code> used to handle response.
     */    
    public ByteBuffer getOutputBB(){
        return outputBB;
    }
    
    
    /**
     * Set the encrypted <code>ByteBuffer</code> used to handle response.
     */   
    public void setOutputBB(ByteBuffer outputBB){
        this.outputBB = outputBB;
    }
    
         
    /**
     * Set the <code>SSLEngine</code>.
     */
    public SSLEngine getSSLEngine() {
        return sslEngine;
    }

        
    /**
     * Get the <code>SSLEngine</code>.
     */
    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }
}

