/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.portunif;

import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import com.sun.enterprise.web.portunif.util.Redirector;
import java.io.IOException;

/**
 * Redirect the request to the proper protocol, which can be http or https.
 *
 * @author Jeanfrancois Arcand
 */
public class HttpProtocolHandler implements ProtocolHandler{
      
    /**
     * The protocols supported by this handler.
     */
    protected String[] protocols = {"https","http"};
    
    
    /**
     * Util to redirect protocol.
     */
    private Redirector redirector;
            
    
    public HttpProtocolHandler() { 
    }

    
    /**
     * Redirect the request to the protocol defined in the 
     * <code>protocolInfo</code>. Protocols supported are http and https.
     * 
     * @param protocolInfo The protocol that needs to be redirected.
     */
    public void handle(ProtocolInfo protocolInfo) throws IOException {
        if (redirector == null){
            redirector = new Redirector();
        }
   
        if (protocolInfo.protocol.equalsIgnoreCase("https")) {
            redirector.redirectSSL(protocolInfo);  
        } else {
            redirector.redirect(protocolInfo); 
        }
        protocolInfo.keepAlive = false;
    }

    
    /**
     * Returns an array of supported protocols.
     * @return an array of supported protocols.
     */
    public String[] getProtocols() {
        return protocols;
    }

}

