/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.portunif.util;

import com.sun.enterprise.web.portunif.ProtocolHandler;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

/**
 * Protocol related struc class. An instance of this class will contains 
 * information on the current protocol used and its associated buffer.
 *
 * @author Jeanfrancois Arcand
 */
public class ProtocolInfo {
    
    public SSLContext sslContext;
    
    public SelectionKey key;
    
    public SSLEngine sslEngine;
    
    public ByteBuffer byteBuffer;
    
    public ByteBuffer inputBB;
    
    public ByteBuffer outputBB;
    
    public SocketChannel socketChannel;
    
    public String protocol = null;
    
    public boolean isSecure = false;
    
    public boolean isRequestedTransportSecure = false;
    
    public boolean handshake = true;
    
    public int bytesRead = 0;
    
    public Map<SelectionKey,ProtocolHandler> mappedProtocols;
    
    public boolean keepAlive = true;
    
    public String requestURI;
       
    public void recycle(){
        sslContext = null;
        key = null;
        sslEngine = null;
        byteBuffer = null;
        inputBB = null;
        outputBB = null;
        socketChannel = null;
        protocol = null;
        isSecure = false;
        isRequestedTransportSecure = false;
        bytesRead = 0;
        keepAlive = true;
        requestURI = null;
        handshake = true;
    }
    
}
