/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.LoopTagSupport;

/**
 * <p>Tag handler for &lt;locales&gt;
 *
 * @author Felipe Leme <jstl@felipeal.net>
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:41 $
 */
public class LocalesTag extends LoopTagSupport {

    private static final Locale[] locales = Locale.getAvailableLocales();
    private int pointer; 
    private String varTotal;

    public void setVarTotal( String value ) {
	varTotal = value;
    }

    public void prepare() {
	pointer = 0;
	if ( varTotal!=null && varTotal.length()>0 ) {
	    pageContext.setAttribute( varTotal, new Integer(locales.length) );
	}
    
    } 

    public boolean hasNext() {
	return pointer < locales.length;
    }  

    public Object next() {
	return locales[ pointer++ ];
    }
  
    public void setBegin( int value ) {
  	super.begin = value;
    }
  
    public void setEnd( int value ) {
  	super.end = value;
    }                     
}
