/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier;

import java.lang.reflect.Method;
import java.lang.reflect.Field;
import java.util.ArrayList;

/**
 * This class represents the fault location of the failed verifier assertions.
 * It can be used by IDE's to open the faulty source file in the editor.
 * 
 * The location object is initialized as part of Result initialization and so it
 * is available in every assertion. Just like every assertion has to populate
 * the result object, it will have to populate this location. 
 * For now, few assertions in package 'tests.ejb.ejb30' are modified to provide 
 * the location information.
 * 
 * @author Vikas Awasthi
 */
public class FaultLocation {

    private Class faultyClass;
    private Method faultyMethod;
    private Field faultyField;
    private String faultyClassName;
    private String faultyMethodName;
    private String[] faultyMethodParams;

    public Class getFaultyClass() {
        return faultyClass;
    }

    public void setFaultyClass(Class faultyClass) {
        this.faultyClass = faultyClass;
    }

    public Method getFaultyMethod() {
        return faultyMethod;
    }

    public void setFaultyMethod(Method faultyMethod) {
        this.faultyMethod = faultyMethod;
    }

    public String getFaultyClassName() {
        if(faultyClassName==null && faultyClass != null)
            faultyClassName = faultyClass.getName();
        return faultyClassName;
    }

    public void setFaultyClassName(String faultyClassName) {
        this.faultyClassName = faultyClassName;
    }

    public String getFaultyMethodName() {
        if(faultyMethodName==null && faultyMethod != null)
            faultyMethodName = faultyMethod.getName();
        return faultyMethodName;
    }

    public void setFaultyMethodName(String faultyMethodName) {
        this.faultyMethodName = faultyMethodName;
    }

    public Field getFaultyField() {
        return faultyField;
    }

    public void setFaultyField(Field faultyField) {
        this.faultyField = faultyField;
    }

    public String[] getFaultyMethodParams() {
        if(faultyMethodParams==null && faultyMethod != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (Class<?> aClass : faultyMethod.getParameterTypes()) 
                l.add(aClass.getName());
            faultyMethodParams = l.toArray(new String[]{});
        }
        return faultyMethodParams;
    }
    
    public void setFaultyClassAndMethod(Method faultyMethod) {
        this.faultyClass = faultyMethod.getDeclaringClass();
        this.faultyMethod = faultyMethod;
    }

    public void setFaultyClassAndField(Field faultyField) {
        this.faultyField = faultyField;
        this.faultyClass = faultyField.getDeclaringClass();
    }
}
