/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.apiscan.classfile;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class MethodRef {
    private String owningClassNameInternal; // in internal form, e.g. com/acme/Address

    private String owningClassName; // in external form, i.e. java.lang.Object

    private String name; // main

    private String descriptor; // ([Ljava.lang.String;)I

    public static final String CLINIT_NAME = "<clinit>"; // NOI18N

    public static final String CLINIT_DESC = "()V"; // NOI18N

    public MethodRef(String owningClassNameInternal, String name, String descriptor) {
        this.owningClassNameInternal = owningClassNameInternal;
        this.owningClassName = Util.convertToExternalClassName(owningClassNameInternal);
        this.name = name;
        this.descriptor = descriptor;
    }

    public String getDescriptor() {
        return descriptor;
    }

    public String getOwningClassNameInternal() {
        return owningClassNameInternal;
    }

    public String getOwningClassName(){
        return owningClassName;
    }

    public String getName() {
        return name;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MethodRef)) return false;
        final MethodRef methodRef = (MethodRef) o;
        if (descriptor != null ?
                !descriptor.equals(methodRef.descriptor) :
                methodRef.descriptor != null)
            return false;
        if (name != null ?
                !name.equals(methodRef.name) : methodRef.name != null)
            return false;
        if (owningClassNameInternal != null ?
                !owningClassNameInternal.equals(methodRef.owningClassNameInternal) :
                methodRef.owningClassNameInternal != null)
            return false;
        return true;
    }

    public int hashCode() {
        int result;
        result = (owningClassNameInternal != null ? owningClassNameInternal.hashCode() : 0);
        result = 29 * result + (name != null ? name.hashCode() : 0);
        result = 29 * result +
                (descriptor != null ? descriptor.hashCode() : 0);
        return result;
    }

    @Override public String toString() {
        return owningClassNameInternal + "." + name + descriptor; // NOI18N
    }
}
