/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.persistence;

import com.sun.enterprise.server.PersistenceUnitInfoImpl;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;

import com.sun.enterprise.loader.InstrumentableClassLoader;
import javax.sql.DataSource;
import java.util.Properties;

/**
 * This class implements {@link javax.persistence.spi.PersistenceUnitInfo}
 * It inherits most of the implementation from its super class, except the
 * implementation that depends on runtime environment. See the details of methods
 * overridden in this class.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class AVKPersistenceUnitInfoImpl extends PersistenceUnitInfoImpl {
    public AVKPersistenceUnitInfoImpl(
            PersistenceUnitDescriptor persistenceUnitDescriptor,
            String applicationLocation,
            InstrumentableClassLoader classLoader) {
        super(persistenceUnitDescriptor, applicationLocation, classLoader);
    }

    /**
     * For verification purpose, we don't need any data-source.
     * @return
     */
    @Override protected DataSource _getJtaDataSource() {
        return null;
    }

    /**
     * For verification purpose, we don't need any data-source.
     * @return
     */
    @Override protected DataSource _getNonJtaDataSource() {
        return null;
    }
}
