/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;


import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Enterprise Java Bean class constuctor test.  
 * The class must have a public constructor that takes no parameters.
 */
public class EjbClassConstructor extends EjbTest { 


    /**
     * Enterprise Java Bean class constuctor test.  
     * The class must have a public constructor that takes no parameters.
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor   
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        Class c = loadEjbClass(descriptor, result);
        if (c!=null) {

            boolean foundOne = false;
            Constructor [] constructors = c.getConstructors();
            for (int i = 0; i < constructors.length; i++) {
                int modifiers = constructors[i].getModifiers();
                if (Modifier.isPublic(modifiers)) {
                    Class [] constructorParameterTypes;
                    constructorParameterTypes = constructors[i].getParameterTypes();
                    if (constructorParameterTypes.length > 0) {
                        continue;
                    } else {
                        foundOne = true;
                        break;
                    }
                }
            }

            if (foundOne) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));
		result.passed(smh.getLocalString
			      (getClass().getName() + ".passed",
			       "Valid: This bean [ {0} ] has a public constructor method with no "
			       + " \n parameters.  Enterprise beans must have a public constructor "
			       + " \n method with no parameters.",
			       new Object[] {descriptor.getEjbClassName()}));
            } else {
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                    "Error: There is no public constructor method with no parameters"
                    + "\n defined within bean [ {0} ].  Enterprise beans must have a "
                    + "\n public constructor methods with no parameters.",
                    new Object[] {descriptor.getEjbClassName()}));
            }
        }
        return result;

    }
}
