/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Modifier;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Enterprise Java Bean class modifiers test.  The class must not be defined 
 * as abstract.
 */
public class EjbClassModifiersAbstract extends EjbTest  { 


    /**
     * Enterprise Java Bean class modifiers test.  The class must not be defined
     * as abstract.
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor   
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
        boolean shouldBeAbstract = false;
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                if (EjbCMPEntityDescriptor.CMP_1_1!=((EjbCMPEntityDescriptor) descriptor).getCMPVersion()) {
                    shouldBeAbstract = true;
                }
            }
        }
        Class c = loadEjbClass(descriptor, result);
        if (c!=null) {

            boolean isAbstract = false;
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                isAbstract = true;
            }

            if (!isAbstract && !shouldBeAbstract) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));
                result.passed(smh.getLocalString
			      (getClass().getName() + ".passed",
			       "[ {0} ] properly declares non-abstract class modifier.",
			       new Object[] {descriptor.getEjbClassName()}));
            }
            if (isAbstract && shouldBeAbstract) {
		result.addGoodDetails(smh.getLocalString
				      ("tests.componentNameConstructor",
				       "For [ {0} ]",
				       new Object[] {compName.toString()}));
                result.passed(smh.getLocalString
			      (getClass().getName() + ".passed2",
			       "[ {0} ] properly declares abstract class modifier.",
			       new Object[] {descriptor.getEjbClassName()}));
            }
            if (isAbstract && !shouldBeAbstract ) {
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                result.failed(smh.getLocalString
			      (getClass().getName() + ".failed",
			       "Error: Ejb Class [ {0} ] was found, but was declared as abstract.  The class  [ {1} ] must not be abstract.",
			       new Object[] {descriptor.getEjbClassName(),descriptor.getEjbClassName()}));
            }
            if (!isAbstract && shouldBeAbstract ) {
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                result.failed(smh.getLocalString
			      (getClass().getName() + ".failed2",
			       "Error: CMP 2.0 Entity Bean Class [ {0} ] was found, but was declared as non abstract.  The class  [ {1} ] must be abstract.",
			       new Object[] {descriptor.getEjbClassName(),descriptor.getEjbClassName()}));
            }
	    
        }
        return result;
 
    }
}
