/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;

import java.util.Set;
import java.lang.reflect.Method;

/**
 * Base class for all interceptor method tests.
 * @author Vikas Awasthi
 */
public abstract class InterceptorMethodTest extends EjbTest {
    Result result;
    ComponentNameConstructor compName;
    abstract void testInterceptorMethods(Set<LifecycleCallbackDescriptor> callbackDescs,
                                         String callbackMethodName,
                                         Boolean isBeanMethod);

    public Result check(EjbDescriptor descriptor) {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        testInterceptorMethods(
                descriptor.getAroundInvokeDescriptors(), "AroundInvoke", true);
        testInterceptorMethods(
                descriptor.getPreDestroyDescriptors(), "PreDestroy", true);
        testInterceptorMethods(
                descriptor.getPostConstructDescriptors(), "PostConstruct", true);

        if(descriptor instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sessionDescriptor = (EjbSessionDescriptor)descriptor;
            testInterceptorMethods(
                    sessionDescriptor.getPrePassivateDescriptors(), "PrePassivate", true);
            testInterceptorMethods(
                    sessionDescriptor.getPostActivateDescriptors(), "PostActivate", true);
        }

        descriptor.getInterceptorClasses();
        for (EjbInterceptor interceptor : descriptor.getInterceptorClasses()) {
            testInterceptorMethods(
                    interceptor.getAroundInvokeDescriptors(), "AroundInvoke", false);
            testInterceptorMethods(
                    interceptor.getPreDestroyDescriptors(), "PreDestroy", false);
            testInterceptorMethods(
                    interceptor.getPostConstructDescriptors(), "PostConstruct", false);
            testInterceptorMethods(
                    interceptor.getCallbackDescriptors(
                            LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE), "PrePassivate", false);
            testInterceptorMethods(
                    interceptor.getCallbackDescriptors(
                            LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE), "PostActivate", false);
        }

        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            ("com.sun.enterprise.tools.verifier.tests.ejb.ejb30.InterceptorMethodTest.passed",
                            "Valid Interceptor methods."));
        }
        return result;
    }

    protected void logFailure(String methodName, Method method) {
        result.getFaultLocation().setFaultyClassAndMethod(method);
        addErrorDetails(result, compName);
        result.failed(smh.getLocalString
                        ("com.sun.enterprise.tools.verifier.tests.ejb.ejb30.InterceptorMethodTest.failed",
                        "Wrong {0} interceptor method [ {1} ]",
                        new Object[] {methodName, method}));
    }
}
