/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;

import java.lang.ClassLoader;

/** 
 *  Interface test.  
 * Verify that the bean local or remote interface class exist and is loadable.
 */
abstract public class InterfaceClassExist extends EjbTest implements EjbCheck { 
    
    
    /**
     * Following 2 methods are used to determine whether this method is being called by 
     * local/remote interface.
     */
    abstract protected String getInterfaceName(EjbDescriptor descriptor);
    abstract protected String getInterfaceType();
    
    /**  
     * Local Interface test.
     * Verify that the bean remote or local interface class exist and is loadable.
     *  
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
        if (!(descriptor instanceof EjbSessionDescriptor) &&
                !(descriptor instanceof EjbEntityDescriptor)) { 
            addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable1",
                    "Test apply only to session or entity beans."));
            return result;
        }
        
        if(getInterfaceName(descriptor) == null || "".equals(getInterfaceName(descriptor))){
            addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable2",
                    "Not Applicable because, EJB [ {0} ] does not have {1} Interface.",
                    new Object[] {descriptor.getEjbClassName(), getInterfaceType()}));
            return result;
        }
        
        // verify that the local or remote interface class exist and is loadable
        try {
            ClassLoader jcl = getVerifierContext().getClassLoader();
            Class c = Class.forName(getClassName(descriptor), false, jcl);
            if(!c.isInterface()) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                        ("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.failed",
                        "[ {0} ] is defined as a class. It should be an interface.",
                        new Object[] {getClassName(descriptor)}));
            }
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                    "Error: "+ getInterfaceType() +" interface [ {0} ] does not exist or is not loadable.",
                    new Object[] {getClassName(descriptor)}));
        }
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);	
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    getInterfaceType() + " interface [ {0} ] exist and is loadable.",
                    new Object[] {getClassName(descriptor)}));
        }
        return result;
    }
    
    private String getClassName(EjbDescriptor descriptor) {
        return getInterfaceName(descriptor);
    }
}
