/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.runtime.beancache;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;


/** ejb [0,n]
 *    bean-cache ?
 *        max-cache-size ? [String]
 *        resize-quantity ? [String]
 *        is-cache-overflow-allowed ? [String]
 *        cache-idle-timout-in-seconds ? [String]
 *        removal-timeout-in-seconds ? [String]
 *        victim-selection-policy ? [String]
 *
 * The max-cache-size specifies the maximum number of beans in the cache.
 * Valid values are between 1 and MAX_INT
 */

public class ASEjbBCResizeQuantity extends ASEjbBeanCache
{
    
    public Result check(EjbDescriptor descriptor)
    {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String beanCache = null;
        String resizeQty = null;
        String maxCacheSize = null;
        try{
            beanCache = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-cache");
            if(beanCache!=null)
            {
                try
                {
                    resizeQty = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-cache/resize-quantity");
                    if (resizeQty!=null)
                    {
                        resizeQty = resizeQty.trim();
                        if (resizeQty.length()==0)
                        {
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(getClass().getName()+".failed",
                                "FAILED [AS-EJB bean-cache] : resize-quantity cannot be empty"));

                        }else
                        {
                            int resizeQtyVal = Integer.valueOf(resizeQty).intValue();
                            if (resizeQtyVal < 1  || resizeQtyVal > Integer.MAX_VALUE)
                            {
                              addErrorDetails(result, compName);
                              result.failed(smh.getLocalString(getClass().getName()+".failed1",
                                    "FAILED [AS-EJB bean-cache] : resize-quantity cannot be less than 1 or greater than {0}", new Object[]{new Integer(Integer.MAX_VALUE)}));
                            }else
                            {
                                int cacheSizeVal=0;
                                maxCacheSize = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-cache/max-cache-size");
                                if (maxCacheSize!=null)
                                {
                                    try{
                                        cacheSizeVal = Integer.valueOf(maxCacheSize).intValue();

                                    }catch(NumberFormatException nfe){
                                        addErrorDetails(result, compName);
                                        result.failed(smh.getLocalString(getClass().getName()+".failed2",
                                            "FAILED [AS-EJB bean-cache] : The value [ {0} ] for max-cache-size is not a valid Integer number",
                                            new Object[]{maxCacheSize}));
                                        return result;
                                    }
                                    if (cacheSizeVal >= 1 && cacheSizeVal <= Integer.MAX_VALUE)
                                    {
                                        if (resizeQtyVal <= cacheSizeVal)
                                        {
                                            addGoodDetails(result, compName);
                                            result.passed(smh.getLocalString(getClass().getName()+".passed",
                                                "PASSED [AS-EJB bean-cache] : resize-quantity is {0} and is less than max-cache-size {1}",
                                                 new Object[]{(new Integer(resizeQty)),new Integer(maxCacheSize)}));
                                        }
                                        else
                                        {
                                            addErrorDetails(result, compName);
                                            result.failed(smh.getLocalString(getClass().getName()+".failed3",
                                                    "FAILED[AS-EJB bean-cache] : resize-quantity {0} should be less than max-cache-size {1}",
                                                    new Object[]{new Integer(resizeQty), new Integer(maxCacheSize)}));
                                        }
                                    }else
                                    {
                                        addErrorDetails(result, compName);
                                        result.failed(smh.getLocalString(getClass().getName()+".failed4",
                                                "FAILED [AS-EJB" +"bean-cache] : resize-quantity should be less than max-cache-size and max-cache-size is not a valid integer"));

                                    }
                                }else
                                {
                                    addGoodDetails(result, compName);
                                    result.passed(smh.getLocalString(getClass().getName()+".passed1",
                                        "PASSED [AS-EJB bean-cache] : resize-quantity is {0}",
                                         new Object[]{(new Integer(resizeQty))}));
                                }
                            }
                        }

                    }else // resize-quantity not defined
                    {
                        addNaDetails(result, compName);
                        result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                          "NOT APPLICABLE [AS-EJB bean-cache] : resize-quantity element is not defined"));

                    }
                }catch(NumberFormatException nfex)
                {
                    Verifier.debug(nfex);
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(getClass().getName()+".failed5",
                            "FAILED [AS-EJB bean-cache] : The value [ {0} ] for resize-quantity is not a valid Integer number",
                            new Object[]{resizeQty}));


                }
            }else //bean-cache element not defined
            {
                addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable1",
                    "NOT APPLICABLE [AS-EJB] : bean-cache element not defined"));

            }
    }catch(Exception ex)
    {
        addErrorDetails(result, compName);
        result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".notRun",
                        "NOT RUN [AS-EJB] : Could not create the descriptor object"));
    }
        return result;
    }
}
