/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.ejb.timer;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

/**
 * Checks if the EJB class implements the TimedObject interface 
 *
 * @version
 * @author Anisha Malhotra
 */
public class ImplementsTimedObjectTest extends EjbTest {

    ComponentNameConstructor compName = null;
    /**
     * Checks if the EJB class implements the TimedObject interface
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName =
                getVerifierContext().getComponentNameConstructor();
        boolean isEjb30 = descriptor.getEjbBundleDescriptor().getSpecVersion().equalsIgnoreCase("3.0");
        if(descriptor.isTimedObject()) {
            //Timers can be created for stateless session beans, message-driven beans,
            //and 2.1 entity beans.Timers cannot be created for stateful session beans or EJB 3.0 entities.
            if(((descriptor instanceof EjbEntityDescriptor) && isEjb30)
                    || ( (descriptor instanceof EjbSessionDescriptor) &&
                    ((((EjbSessionDescriptor)descriptor).getSessionType()).equals
                    (EjbSessionDescriptor.STATEFUL)) )) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString(getClass().getName()+
                        ".failed1", "[ {0} ] must not implement the TimedObject interface." +
                        "Only 2.1 entity beans or stateless session beans may " +
                        "implement the TimedObject interface" ,
                        new Object[] {descriptor.getEjbClassName()}));
            }
        }
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString (getClass().getName()+".passed",
                    "[ {0} ] properly implements the TimedObject interface",
                    new Object[] {descriptor.getEjbClassName()}));

        }
        return result;
    }
}
