/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Servlet lib directory resides in WEB-INF/lib directory test.
 */
public class LibDirExists extends WebTest implements WebCheck { 

    final String servletLibDirPath = "WEB-INF/lib";
      
    /** 
     * Servlet lib directory resides in WEB-INF/lib directory test.
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (!descriptor.getServletDescriptors().isEmpty()) {
	    boolean oneFailed = false;
	    int na = 0;
	    boolean foundIt = false;
	    // get the servlets in this .war
	    Set servlets = descriptor.getServletDescriptors();
	    Iterator itr = servlets.iterator();
	    // test the servlets in this .war
	    while (itr.hasNext()) {
		foundIt = false;
		WebComponentDescriptor servlet = (WebComponentDescriptor)itr.next();
//		try {
                    File warfile = new File(System.getProperty("java.io.tmpdir"));
		    warfile = new File(warfile, "wartmp");
//                    File f = Verifier.getArchiveFile(
//                             descriptor.getModuleDescriptor().getArchiveUri());
		    File warLibDir = null;

//                    if (f != null) {
//                        VerifierUtils.copyArchiveToDir(f, warfile);
//		        warLibDir = new File(warfile, servletLibDirPath);
//                    }
//                    else {
                      String uri = getAbstractArchiveUri(descriptor);
		      warLibDir = new File(uri, servletLibDirPath);
//                    }

                    if (warLibDir.isDirectory()) {
		        foundIt = true;
                    } 
/*		} catch (IOException e) {
		    if (!oneFailed ) {
			oneFailed = true;
		    }
		    Verifier.debug(e);
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

		    result.addErrorDetails(smh.getLocalString
					   (getClass().getName() + ".IOException",
					    "Error: IOError trying to open [ {0} ], {1}",
					    new Object[] {Verifier.getArchiveFile(descriptor.getModuleDescriptor().getArchiveUri()), e.getMessage()}));
		}*/
   
		if (foundIt) {
		    result.addGoodDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Servlet lib dir [ {0} ] resides in WEB-INF/lib directory of [ {1} ].",
					   new Object[] {servletLibDirPath,uri}));
		} else {
		    na++;
		    result.addNaDetails(smh.getLocalString
					("tests.componentNameConstructor",
					 "For [ {0} ]",
					 new Object[] {compName.toString()}));
		    result.addNaDetails(smh.getLocalString
					   (getClass().getName() + ".notApplicable2",
					    "Servlet lib dir [ {0} ] does not reside in [ {1} ].",
					    new Object[] {servletLibDirPath,uri}));
		}
	    }
            File wartmp = new File(System.getProperty("java.io.tmpdir"));
	    wartmp = new File(wartmp, "wartmp");
	    deleteDirectory(wartmp.getAbsolutePath());
	    if (na == descriptor.getServletDescriptors().size()) {
		result.setStatus(Result.NOT_APPLICABLE);
	    } else if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no servlet components within the web archive [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}
	return result;
    }   
}
