/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;

/** 
 * Listener class must implement a valid interface.
 * Verify that the Listener class implements one of five valid interfaces.
 * 
 * @author Jerome Dochez
 * @version 1.0
 */
public class ListenerClassImplementsValidInterface extends ListenerClass implements WebCheck {
        
    /**
     * <p>
     * Run the verifier test against a declared individual listener class
     * </p>
     *
     * @param result is used to put the test results in
     * @param listenerClass is the individual listener class object to test
     * @return true if the test pass
     */
    protected boolean runIndividualListenerTest(Result result, Class listenerClass) {
        
        boolean validInterface = false;
        Class clazz = listenerClass;
        
        if (listenerClass==null) {
            return false;
        }
        
	validInterface = isImplementorOf(clazz,"javax.servlet.ServletContextAttributeListener");
	if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.ServletContextListener");
	}
	if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.http.HttpSessionAttributeListener");
	}
	if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.http.HttpSessionListener");
	}
    if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.ServletRequestAttributeListener");
	}if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.ServletRequestListener");
	}if (validInterface != true) {
	    validInterface = isImplementorOf(clazz,"javax.servlet.http.HttpSessionBindingListener");
	}

         if (validInterface) {
             result.addGoodDetails(smh.getLocalString
                (getClass().getName() + ".passed",
                 "Listener class [ {0} ] implements a valid interface.",
                 new Object[] {listenerClass.getName()}));
         } else if (!validInterface){
             result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".failed",
                 "Error: Listener class [ {0} ] does not implement one or more of the following valid interface.\n javax.servlet.ServletContextAttributeListener, javax.servlet.ServletContextListener, javax.servlet.http.HttpSessionAttributeListener, javax.servlet.http.HttpSessionListener",
                  new Object[] {clazz.getName()}));
	 }
	    	                     
        return validInterface;
    }
}
