/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.tests.AbstractPUMatchingEMandEMFRefTest;

import java.util.Collection;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 * @see AbstractPUMatchingEMRefTest
 */
public class PUMatchingEMandEMFRefTest extends AbstractPUMatchingEMandEMFRefTest {
    protected WebBundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return WebBundleDescriptor.class.cast(descriptor);
    }

    protected Collection<EntityManagerReferenceDescriptor>
            getEntityManagerReferenceDescriptors(Descriptor descriptor) {
        return WebBundleDescriptor.class.cast(descriptor)
                .getEntityManagerReferenceDescriptors();
    }
    
    protected Collection<EntityManagerFactoryReferenceDescriptor>
            getEntityManagerFactoryReferenceDescriptors(Descriptor descriptor) {
        return WebBundleDescriptor.class.cast(descriptor)
                .getEntityManagerFactoryReferenceDescriptors();
    }
    
}

