/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.util.FileClassLoader;


/** 
 * The transport-guarantee element specifies that the communication between 
 * client and server should be "SECURE", "NONE", or "CONFIDENTIAL". 
 */
public class TransportGuarantee extends WebTest implements WebCheck { 

    
    /**
     * The transport-guarantee element specifies that the communication between 
     * client and server should be "SECURE", "NONE", or "CONFIDENTIAL". 
     *
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor.getSecurityConstraints().hasMoreElements()) {
	    boolean oneFailed = false;
	    boolean foundIt = false;
	    int na = 0;
	    int noSc = 0;
	    // get the errorpage's in this .war
	    for (Enumeration e = descriptor.getSecurityConstraints() ; e.hasMoreElements() ;) {
		foundIt = false;
                noSc++;
		SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl) e.nextElement();
		UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl) securityConstraintImpl.getUserDataConstraint();
		if (userDataConstraint != null) {
                    String transportGuarantee = userDataConstraint.getTransportGuarantee(); 
		    if (transportGuarantee.length() > 0) {
		        if ((transportGuarantee.equals("NONE")) ||
			    (transportGuarantee.equals("INTEGRAL")) ||
			    (transportGuarantee.equals("CONFIDENTIAL"))) {
			    foundIt = true;
		        } else {
			    foundIt = false;
		        }
		    } else {
		        foundIt = false;
		    }
         
		    if (foundIt) {
			result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		        result.addGoodDetails(smh.getLocalString
					      (getClass().getName() + ".passed",
					       "transport-guarantee [ {0} ] specifies that the communication between client and server should be one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]",
					       new Object[] {transportGuarantee, descriptor.getName()}));
		    } else {
		        if (!oneFailed) {
			    oneFailed = true;
		        }
			result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		        result.addErrorDetails(smh.getLocalString
					       (getClass().getName() + ".failed",
					        "Error: transport-guarantee [ {0} ] does not specify that the communication between client and server is one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]",
					        new Object[] {transportGuarantee, descriptor.getName()}));
		    }
	        } else {
		    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	            result.addNaDetails(smh.getLocalString
			 (getClass().getName() + ".notApplicable1",
			  "There are no transport-guarantee elements within the web application [ {0} ]",
			  new Object[] {descriptor.getName()}));
                    na++;
	        }
	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else if (na == noSc) {
		result.setStatus(Result.NOT_APPLICABLE);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no transport-guarantee elements within the web archive [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

	return result;
    }
}
