/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.*;

/* 
 *   @class.setup_props: ; 
 */ 

/* 
 *   @testName: check  
 *   @assertion_ids: JSR109_WS_1
 *   @test_Strategy:  
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription :If the Service Implementation Bean is an EJB, 
 *   the transaction attributes for the methods defined by the SEI do not include Mandatory.
 */ 
public class SEIEJBTxAttrChk extends WSTest implements WSCheck {

    /**
     * @param descriptor the  WebService deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (WebServiceEndpoint wsdescriptor) {

	Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        boolean pass = true;

        if (wsdescriptor.implementedByEjbComponent()) {

          EjbDescriptor descriptor = wsdescriptor.getEjbComponentImpl();

	  try  {
             ContainerTransaction ctx = descriptor.getContainerTransaction();

             if ((ctx != null) && 
                 (ContainerTransaction.MANDATORY.equals(ctx.getTransactionAttribute()))) {
                 // Call result.failed here : All methods are having Mandatory TX
                  result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                                   "For [ {0} ]", new Object[] {compName.toString()}));
                  result.failed(smh.getLocalString (getClass().getName() + ".failed",
                  "[{0}] of this WebService [{1}] have Mandatory Transaction Attribute.",
                  new Object[] {"All the methods", compName.toString()}));

                 return result;
             }

             Collection txMethDescs = descriptor.getTransactionMethodDescriptors();

             // get hold of the SEI Class
             String s = descriptor.getWebServiceEndpointInterfaceName();

             if (s == null) {
               // internal error, should never happen
                result.addErrorDetails(smh.getLocalString
               ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                "Error: Unexpected error occurred [ {0} ]",
                new Object[] {"Service Endpoint Interface Class Name Null"}));
                pass = false;
             }	
             ClassLoader cl = getVerifierContext().getClassLoader();
             Class sei = null;

             try {
                sei = Class.forName(s, false, cl);
             }catch(ClassNotFoundException e) {
               result.addErrorDetails(smh.getLocalString
               ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                "Error: Unexpected error occurred [ {0} ]",
                new Object[] {"Could not Load Service Endpoint Interface Class"}));
                pass = false;
             }

             Iterator it = txMethDescs.iterator(); 
             while (it.hasNext()) {
               // need to check if this method is part of SEI
               MethodDescriptor methdesc =(MethodDescriptor)it.next();
              if (isSEIMethod(methdesc, descriptor, sei, cl)) {
                  ctx = descriptor.getContainerTransactionFor(methdesc);
                  if ((ctx != null) && 
                     (ContainerTransaction.MANDATORY.equals(ctx.getTransactionAttribute()))) {
                     // Call result.failed here with Method details here
                     result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                                   "For [ {0} ]", new Object[] {compName.toString()}));
                     result.failed(smh.getLocalString (getClass().getName() + ".failed",
                     "[{0}] of this WebService [{1}] have Mandatory Transaction Attribute.",
                     new Object[] {methdesc.getName(), compName.toString()}));
                     pass = false;
                   }
               }
             }
           } catch (Exception e) {
             // Call result.addErrorDetails here with exception details
               result.addErrorDetails(smh.getLocalString
               ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                "Error: Unexpected error occurred [ {0} ]",
                new Object[] {e.getMessage()}));
                pass = false;
           }

          if (pass) {

           result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
           result.passed(smh.getLocalString (getClass().getName() + ".passed",
                    "None of the methods of this WebService [{0}] have Mandatory Transaction Attribute.",
                           new Object[] {compName.toString()}));

          }
          
          return result;
         }
         else {
          // call result.notapplicable
          result.addNaDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
          result.notApplicable(smh.getLocalString (getClass().getName() + ".notapp",
                 "Not applicable since this is not an EJB Service Endpoint.")); 

          return result;
         }
       }
 }

