/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NodeList;

/**
 *
 * Class which represents WEB-INF/faces-config.xml
 *
 * @author bshankar@sun.com
 *
 */
public class FacesConfigDescriptor {
    
    private final String MANAGED_BEAN_CLASS = "managed-bean-class"; // NOI18N
    private final String facesConfigFileName = "WEB-INF/faces-config.xml"; // NOI18N
    
    private Context context;
    private Document facesConfigDocument;
    
    public FacesConfigDescriptor(Context context, WebBundleDescriptor descriptor) {
        try {
            this.context = context;
            readFacesConfigDocument(descriptor);
        } catch(Exception ex) {
            facesConfigDocument = null;
        }
    }
    
    private void readFacesConfigDocument(WebBundleDescriptor webd) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ModuleDescriptor moduleDesc = webd.getModuleDescriptor();
        String archBase = context.getAbstractArchive().getArchiveUri();
        String uri = null;
        if(moduleDesc.isStandalone()){
            uri = archBase;
        } else {
            uri = archBase + File.separator +
                    FileUtils.makeFriendlyFileName(moduleDesc.getArchiveUri());
        }
        FileArchive arch = new FileArchive();
        arch.open(uri);
        InputStream is = arch.getEntry(facesConfigFileName);
        InputSource source = new InputSource(is);
        try {
            facesConfigDocument = builder.parse(source);
        } finally {
            try{
                if(is != null)
                    is.close();
            } catch(Exception e) {}
        }
    }
    
    public List<String> getManagedBeanClasses() {
        if (facesConfigDocument == null) {
            return new ArrayList<String>();
        }
        NodeList nl = facesConfigDocument.getElementsByTagName(MANAGED_BEAN_CLASS);
        List<String> classes = new ArrayList<String>();
        if (nl != null) {
            int size = nl.getLength();
            for (int i = 0; i < size; i++) {
                classes.add(nl.item(i).getFirstChild().getNodeValue().trim());
            }
        }
        return classes;
    }
    
}
