/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a long constant in the constant pool of a class file
 */

public class ConstLong extends ConstValue {
  /* The tag value associated with ConstLong */
  public static final int MyTag = CONSTANTLong;

  /* The value */
  private long longValue;

  /* public accessors */

  /**
   * The tag of this constant entry
   */
  public int tag () { return MyTag; }

  /**
   * return the value associated with the entry
   */
  public long value() {
    return longValue;
  }

  /**
   * Return the descriptor string for the constant type.
   */
  public String descriptor() {
      return "J";//NOI18N
  }

  /**
   * A printable representation
   */
  public String toString () {
      return "CONSTANTLong(" + indexAsString() + "): " + //NOI18N
          "longValue(" + Long.toString(longValue) + ")";//NOI18N
  }

  /* package local methods */

  ConstLong (long i) {
    longValue = i;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeLong(longValue);
  }

  static ConstLong read (DataInputStream input) throws IOException {
    return new ConstLong (input.readLong());
  }

  void resolve (ConstantPool p) { }


}

