/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PersistenceElementImpl.java
 *
 * Created on March 1, 2000, 5:01 PM
 */

package com.sun.jdo.api.persistence.model.jdo.impl;

import java.beans.*;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElementProperties;

/* TODO:
	1. way to get to declaring class from here?
 */

/** 
 *
 * @author raccah
 * @version %I%
 */
public abstract class PersistenceElementImpl extends Object 
	implements PersistenceElement.Impl, PersistenceElementProperties
{
	/** Element */
	PersistenceElement _element;

	/** Property change support */
	private PropertyChangeSupport _support;

	/** Vetoable change support */
	private transient VetoableChangeSupport _vetoableSupport;

	/** Name of the element. */
	private String _name;

	/** Create new PersistenceElementImpl with no corresponding name.  This 
	 * constructor should only be used for cloning and archiving.
	 */
	public PersistenceElementImpl ()
	{
		this(null);
	}

	/** Creates new PersistenceElementImpl with the corresponding name 
	 * @param name the name of the element
	 */
	public PersistenceElementImpl (String name)
	{
		super();
		_name = name;
	}

	/** Called to attach the implementation to a specific
	 * element. Will be called in the element's constructor.
	 * Allows implementors of this interface to store a reference to the
	 * holder class, useful for implementing the property change listeners.
	 *
	 * @param element the element to attach to
	 */
	public void attachToElement (PersistenceElement element)
	{
		_element = element;
	}

	/** Fires property change event.
	 * @param name property name
	 * @param o old value
	 * @param n new value
	 */
	protected void firePropertyChange (String name, Object o, Object n)
	{
		if (_support != null)
			_support.firePropertyChange(name, o, n);
	}

	/** Add a property change listener.
	 * @param l the listener to add
	 */
	public synchronized void addPropertyChangeListener 
		(PropertyChangeListener l)
	{
		if (_support == null)
		{
			synchronized(this)
			{
				// new test under synchronized block
				if (_support == null)
					_support = new PropertyChangeSupport(_element);
			}
		}

		_support.addPropertyChangeListener(l);
	}

	/** Remove a property change listener.
	 * @param l the listener to remove
	 */
	public synchronized void removePropertyChangeListener (
		PropertyChangeListener l)
	{
		if (_support != null)
			_support.removePropertyChangeListener(l);
	}

	/** Fires vetoable change event.
	 * @param name property name
	 * @param o old value
	 * @param n new value
	 * @exception PropertyVetoException when the change is vetoed by a listener
	 */
	protected void fireVetoableChange (String name, Object o, Object n)
		throws PropertyVetoException
	{
		if (_vetoableSupport != null)
			_vetoableSupport.fireVetoableChange(name, o, n);
	}

	/** Add a vetoable change listener.
	 * @param l the listener to add
	 */
	public synchronized void addVetoableChangeListener 
		(VetoableChangeListener l)
	{
		if (_vetoableSupport == null)
			_vetoableSupport = new VetoableChangeSupport(_element);

		_vetoableSupport.addVetoableChangeListener(l);
	}

	/** Remove a vetoable change listener.
	 * @param l the listener to remove
	 */
	public synchronized void removeVetoableChangeListener (
		VetoableChangeListener l)
	{
		if (_vetoableSupport != null)
			_vetoableSupport.removeVetoableChangeListener(l);
	}

	/** Get the name of this persistence element.
	 * @return the name
	 */
	public String getName () { return _name; }

	/** Set the name of this persistence element.
	 * @param name the name
	 * @exception ModelException if impossible
	 */
	public void setName (String name) throws ModelException
	{
		String old = getName();

		try
		{
			fireVetoableChange(PROP_NAME, old, name);
			_name = name;
			firePropertyChange(PROP_NAME, old, name);
		}
		catch (PropertyVetoException e)
		{
			throw new ModelVetoException(e);
		}
 	}
}
