/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MappingElementProperties.java
 *
 * Created on April 28, 2000, 6:24 PM
 */

package com.sun.jdo.api.persistence.model.mapping;

/** 
 *
 * @author raccah
 * @version %I%
 */
public interface MappingElementProperties
{
	/** Name of {@link MappingElement#getName name} property.
	 */
	public static final String PROP_NAME = "name";					// NOI18N

	/** Name of {@link MappingClassElement#isModified modified}
	 * flag for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_MODIFIED = "modified";			// NOI18N

	/** Name of {@link MappingClassElement#getConsistencyLevel consistencyLevel}
	 * property for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_CONSISTENCY = "consistencyLevel";	// NOI18N

	/** Name of {@link MappingClassElement#setDatabaseRoot root}
	 * property for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_DATABASE_ROOT = "schema";	// NOI18N

	/** Name of {@link MappingClassElement#getTables tables}
	 * property for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_TABLES = "tables";				// NOI18N

	/** Name of {@link MappingClassElement#getFields fields}
	 * property for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_FIELDS = "fields";				// NOI18N

	/** Name of {@link MappingClassElement#isNavigable navigable}
	 * property for {@link MappingClassElement class elements}.
	 */
	public static final String PROP_NAVIGABLE = "navigable";		// NOI18N

	/** Name of {@link MappingFieldElement#isReadOnly read only}
	 * property for {@link MappingFieldElement field elements}.
	 */
	public static final String PROP_READ_ONLY = "readOnly";			// NOI18N

	/** Name of {@link MappingFieldElement#isInConcurrencyCheck in concurrency 
	 * check} property for {@link MappingFieldElement field elements}.
	 */
	public static final String PROP_IN_CONCURRENCY_CHECK = 
		"inConcurrencyCheck";										// NOI18N

	/** Name of {@link MappingFieldElement#isVersion version field} 
	 * property for {@link MappingFieldElement field elements}.
	 */
	public static final String PROP_VERSION_FIELD = "versionField";		// NOI18N

	/** Name of {@link MappingFieldElement#getFetchGroup fetch group} 
	 * property for {@link MappingFieldElement field elements}.
	 */
	public static final String PROP_FETCH_GROUP = "fetchGroup";		// NOI18N

	/** Name of {@link MappingFieldElement#getColumns columns} 
	 * property for {@link MappingFieldElement field elements}.
	 */
	public static final String PROP_COLUMNS = "columns";			// NOI18N

	/** Name of {@link MappingReferenceKeyElement#getTable table} and 
	 * {@link MappingTableElement#getTable table} property for 
	 * {@link MappingReferenceKeyElement reference key elements} and 
	 * {@link MappingTableElement mapping table elements}.
	 */
	public static final String PROP_TABLE = "table";				// NOI18N

	/** Name of {@link MappingReferenceKeyElement#getReferencingKey key columns}
	 * and {@link MappingTableElement#getKey key columns} property for 
	 * {@link MappingReferenceKeyElement reference key elements} and 
	 * {@link MappingTableElement mapping table elements}.
	 */
	public static final String PROP_KEY_COLUMNS = "keyColumns";		// NOI18N

	/** Name of {@link MappingRelationshipElement#getAssociatedColumns 
	 * associated columns} property for {@link MappingRelationshipElement 
	 * relationship elements}.
	 */
	public static final String PROP_ASSOCIATED_COLUMNS = 
		"associatedColumns";										// NOI18N

	/** Name of {@link MappingTableElement#getReferencingKeys referencing 
	 * keys} property for {@link MappingTableElement mapping table elements}.
	 */
	public static final String PROP_REFERENCING_KEYS = 
		"referencingKeys";											// NOI18N
}
