/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */



/*
 * CMPROTemplateFormatter.java
 *
 * Created on March 03, 2004
 */

package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import java.io.*;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This is the helper class for JDO specific generation of
 * a read-only concrete bean implementation.
 * This class does not extend CMPTemplateFormatter but only references
 * its variables when necessary. This allows to reuse CMPTemplateFormatter's
 * properties but the corresponding templates and formatters must be accessed
 * directly.
 *
 * @author Marina Vatkina
 */
public class CMPROTemplateFormatter {

    private final static String templateFile =
        "com/sun/jdo/spi/persistence/support/ejb/ejbc/CMPROTemplates.properties"; // NOI18N

    // Strings for CMP code generation:
    public final static String updateNotAllowed_    = "updateNotAllowed"; // NOI18N
    public final static String accessNotAllowed_    = "accessNotAllowed"; // NOI18N
    public final static String loadNonDFG_          = "loadNonDFG"; // NOI18N

    // Code generator templates.
    public static Properties helpers = null;

    // variables
    public static MessageFormat privatetransientvformatter = null; // privateTransientVariables

    // methods
    public static MessageFormat giformatter = null; // jdoGetInstance
    public static MessageFormat jdolookuppmfformatter = null; // jdoLookupPersistenceManagerFactory
    public static MessageFormat ejb__refreshformatter = null; // ejb__refresh
    public static MessageFormat loadNonDFGformatter       = null; // loadNonDFG

    // standard templates for the corresponding keys, so that a template "xxxTemplate"
    // corresponds to a "xxx" key.
    public static String privateStaticVariablesTemplate = null;
    public static String signatureTemplate = null;
    public static String updateNotAllowedTemplate = null;
    public static String accessNotAllowedTemplate = null;
    public static String jdoCleanAllRefsTemplate = null;

    // standard method bodies for the corresponding keys, so that a method body with
    // a name "xxxBody" corresponds to a "xxx" key.
    public static String[] jdoGetPersistenceManagerBody = null;
    public static String[] jdoReleasePersistenceManagerBody = null;

    /**
     * Constructs a new <code>CMPROTemplateFormatter</code> instance.
     */
    CMPROTemplateFormatter() {
    }

    /**
     * Initializes templates for code generation.
     */
    static synchronized void initHelpers() throws IOException {
        if (helpers == null) {
            helpers = new Properties();
            CMPTemplateFormatter.loadProperties(helpers, templateFile);

            initFormatters();
            initTemplates();
        }
    }

    /**
     * Initializes MessageFormats for code generation.
     */
    private static void initFormatters() {
        // variables
        privatetransientvformatter = new MessageFormat(helpers.getProperty(
                CMPTemplateFormatter.privateTransientVariables_));

        // methods
        giformatter = new MessageFormat(helpers.getProperty(
                CMPTemplateFormatter.getInstance_));
        jdolookuppmfformatter = new MessageFormat(helpers.getProperty(
                CMPTemplateFormatter.jdoLookupPersistenceManagerFactory_));
        ejb__refreshformatter = new MessageFormat(helpers.getProperty(
                CMPTemplateFormatter.ejb__refresh_));
        loadNonDFGformatter = new MessageFormat(helpers.getProperty(loadNonDFG_));
    }

    /**
     * Initializes standard templates for code generation.
     */
    private static void initTemplates() {
        privateStaticVariablesTemplate = helpers.getProperty(
                CMPTemplateFormatter.privateStaticVariables_);
        signatureTemplate = helpers.getProperty(CMPTemplateFormatter.signature_);
        updateNotAllowedTemplate = helpers.getProperty(updateNotAllowed_);
        accessNotAllowedTemplate = helpers.getProperty(accessNotAllowed_);
        jdoCleanAllRefsTemplate = helpers.getProperty(CMPTemplateFormatter.jdoCleanAllRefs_);

        jdoGetPersistenceManagerBody = CMPTemplateFormatter.getBodyAsStrings(
                helpers.getProperty(CMPTemplateFormatter.jdoGetPersistenceManager_));
        jdoReleasePersistenceManagerBody = CMPTemplateFormatter.getBodyAsStrings(
                helpers.getProperty(CMPTemplateFormatter.jdoReleasePersistenceManager_));
    }
}
