/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */



/*
 * EJBQLException.java
 *
 * Created on November 12, 2001
 */

package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

/** 
 * This class represents errors reported by the EJBQL compiler.
 * 
 * @author  Michael Bouschen
 */
public class EJBQLException 
    extends RuntimeException
{
    /** The Throwable that caused this EJBQLException. */
    Throwable cause;

    /**
     * Creates a new <code>EJBQLException</code> without detail message.
     */
    public EJBQLException() 
    {
    }

    /**
     * Constructs a new <code>EJBQLException</code> with the specified 
     * detail message.
     * @param msg the detail message.
     */
    public EJBQLException(String msg) 
    {
        super(msg);
    }
    
    /**
      * Constructs a new <code>EJBQLException</code> with the specified 
      * detail message and cause.
      * @param msg the detail message.
      * @param cause the cause <code>Throwable</code>.
      */
    public EJBQLException(String msg, Throwable cause) 
    {
        super(msg);
        this.cause = cause;
    }
    
    /**
     * Returns the cause of this <code>EJBQLException</code> or 
     * <code>null</code> if the cause is nonexistent or unknown.  
     * @return the cause of this or <code>null</code> if the
     * cause is nonexistent or unknown.
     */
    public Throwable getCause()
    {
        return cause;
    }

    /** 
     * The <code>String</code> representation includes the name of the class,
     * the descriptive comment (if any),
     * and the <code>String</code> representation of the cause 
     * <code>Throwable</code> (if any).
     * @return the <code>String</code>.
     */
    public String toString() {
        // calculate approximate size of the String to return
        StringBuffer sb = new StringBuffer();
        sb.append (super.toString());
        // include cause Throwable information
        if (cause != null) {
            sb.append("\n");  //NOI18N
            sb.append("Nested exception"); //NOI18N
            sb.append("\n");  //NOI18N
            sb.append(cause.toString());
        }
        return sb.toString();
    }    
}
