/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import org.netbeans.modules.dbschema.ColumnElement;

import java.util.ArrayList;

/**
 * Implements the select plan for correlated subqueries.
 *
 * @author Mitesh Meswani
 * @author Markus Fuchs
 */
public abstract class CorrelatedSelectPlan extends SelectQueryPlan {
    /** The parent plan for this subquery */
    protected SelectQueryPlan parentPlan;

    public CorrelatedSelectPlan(RetrieveDesc desc,
                                SQLStoreManager store,
                                ForeignFieldDesc parentField,
                                SelectQueryPlan parentPlan) {

        super(desc, store, null);
        this.parentField = parentField;
        this.parentPlan = parentPlan;
    }

    /**
     * The constraints for correlated subqueries are added here.
     * The constraints are:
     * <ul>
     * <li>The correlated constraint joining this subquery with the parent plan</li>
     * <li>A join constraint if the parent field uses join table</li>
     * </ul>
     */
    protected void processConstraints() {

        // Process the constraint on the stack.`
        super.processConstraints();

        doCorrelatedJoin();

        processJoinTable();

        // Process any extra statement added as the result of #addTable.
        processStatements();
    }

    /**
     * Must be implemented by the sub classes.
     */
    protected abstract void doCorrelatedJoin();

    /**
     * Enhance the select statement to include the join table if the
     * relationship is mapped via a join table.
     */
    private void processJoinTable() {

        if (parentField.useJoinTable()) {
            addQueryTables(parentField.assocForeignColumns, config);

            // Put in a join for the association table.
            // Subqueries always join via equijoin.
            addJoinConstraint(this, this,
                    parentField.assocForeignColumns,
                    parentField.foreignColumns, ActionDesc.OP_EQUIJOIN);
        }
    }

    /**
     * Adds the query tables corresponding to the columns in <code>columnList</code>.
     *
     * @param columnList List of columns.
     * @param config Class configuration corresponding to columns.
     */
    protected void addQueryTables(ArrayList columnList, ClassDesc config) {
        for (int i = 0; i < columnList.size(); i++) {
            ColumnElement col = (ColumnElement) columnList.get(i);
            addQueryTable(col.getDeclaringTable(), config);
        }
    }

}
