/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.utility;

import java.util.ResourceBundle;
import com.sun.jdo.spi.persistence.utility.logging.Logger;

/** Implements a simple semaphore that does not do <em>any</em>
 * semaphore-ing.  That is, the methods just immediately return.
 *
 * @author Dave Bristor
 */
// db13166: I would rather we use Doug Lea's stuff, but don't want to
// introduce that magnitude of change at this point in time.
public class NullSemaphore implements Semaphore {
    /** Where to log messages about locking operations
     */
    private static final Logger _logger = LogHelperUtility.getLogger();

    /** For logging, indicates on whose behalf locking is done.
     */
    private final String _owner;

    /**
     * I18N message handler
     */
    private final static ResourceBundle messages = 
        I18NHelper.loadBundle(SemaphoreImpl.class);

    public NullSemaphore(String owner) {
        _owner = owner;

        if (_logger.isLoggable(Logger.FINEST)) {
            Object[] items = new Object[] {_owner};
            _logger.finest("utility.nullsemaphore.constructor",items); // NOI18N
        }
    }

    /** Does nothing.
     */
    public void acquire() {

        if (_logger.isLoggable(Logger.FINEST)) {
            Object[] items = new Object[] {_owner};
            _logger.finest("utility.nullsemaphore.acquire",items); // NOI18N
        }
    }

    /** Does nothing.
     */
    public void release() {

        if (_logger.isLoggable(Logger.FINEST)) {
            Object[] items = new Object[] {_owner};
            _logger.finest("utility.nullsemaphore.release",items); // NOI18N
        }
    }
}
