/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * This exception is thrown to signal any BackingStore specific exception.
 * <code>BackingStore.getCause()</code> can be used to get the actual store
 * specific exception.
 */
public class BackingStoreException extends Exception {

    /**
     * Creates a BackingStoreException with null as its detail message. The
     * cause is not initialized, and may subsequently be initialized by a call
     * to <code>Throwable.initCause(java.lang.Throwable)</code>.
     */
    public BackingStoreException() {
    }

    /**
     * constructs a BackingStoreException with the specified detail message
     * 
     * @param message
     *            the detail message. The detail message is saved for later
     *            retrieval by the <code>Throwable.getMessage()</code> method.
     */
    public BackingStoreException(String message) {
        super(message);
    }

    /**
     * Constructs a new BackingStoreException exception with the specified cause
     * and a detail message of (cause==null ? null : cause.toString())
     * 
     * @param message
     *            the detail message. The detail message is saved for
     * @param th
     *            the cause
     */
    public BackingStoreException(String message, Throwable th) {
        super(message, th);
    }

}
