/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

import java.util.Properties;

/**
 * A factory for creating BackingStore(s). Every provider must provide an
 * implementation of this interface.
 * 
 * <p>
 * The <code>createBackingStore(env)</code> method is called typically during
 * container creation time. A store instance is typically used to store state
 * for a single container whose id is passed (as appId) to
 * <code>createStore()</code> method.
 * 
 * <p>
 * The <code>createBatchBackingStore()</code> method will be called whenever
 * the container decides to save a set of states that belong different
 * applications. Thus the store returned by createBatchBackingStore method is
 * different from createBackingStore in that the data passed in the collection
 * may potentially be from different containers/applications.
 * 
 * <p>
 * Any runtime exception thrown from createBackingStore and
 * createBatchBackingStore method will cause the container to use a default
 * persistence-type (typically no replication) and a log message will be logged
 * at WARNING level.
 * 
 * <p>
 * Both <code>BackingStore</code> and <code>BatchBackingStore</code> must be
 * thread safe.
 * 
 * @see BackingStoreRegistry
 * 
 */
public interface BackingStoreFactory {

    /**
     * This method is called to create a BackingStore that will store
     * <code>SimpleMetadata</code> or <code>CompositeMetadata</code>. This
     * class must be thread safe.
     * <p>
     * The factory must return a fully initialized and operational BackingStore
     * 
     * @param type
     *            The type of data that will be saved (using the
     *            <code>save()</code> method in BackingStore) in the store.
     * @param appId
     *            the application id for which this store is created
     * @param env
     *            Properties that contain any additional configuration paramters
     *            to successfully initialize and use the store.
     * @return a BackingStore. The returned BackingStore will be used only to
     *         store data of type K. The returned BackingStore must be thread
     *         safe.
     * @throws BackingStoreException
     *             If the store could not be created
     */
    public <K extends Metadata> BackingStore<K> createBackingStore(
            Class<K> type, String appId, Properties env)
            throws BackingStoreException;

    /**
     * This method is called to store a set of BatchMetadata objects atomically.
     * The factory must return a fully initialized and operational
     * BatchBackingStore
     * <p>
     * The factory must return a fully initialized and operational
     * BatchBackingStore
     * 
     * @param env
     *            Properties that contain any additional configuration paramters
     *            to successfully initialize and use the store.
     * @return A BatchBackingStore
     * @throws BackingStoreException
     *             If the store could not be created
     */
    public BatchBackingStore createBatchBackingStore(Properties env)
            throws BackingStoreException;

}
